package com.example.afrishop_v3.util;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *
 * @author mds
 * @DateTime 2018年4月25日 上午11:30:01
 * @Comment xml工具类
 */
public class XmlUtil {
	private final static Logger logger = LoggerFactory.getLogger(XmlUtil.class);
	
	/**  
	* @author mds 
	* @DateTime 2018年4月25日 上午11:32:59 
	* @serverComment 
	*          xml转Map
	*
	* @return         
	*/
	@SuppressWarnings("unchecked")
	public static Map<String, String> xmlToMap(InputStream ins){
		Map<String, String> map = new HashMap<String, String>();
		SAXReader reader = new SAXReader();
		Document doc = null;
		try {
			doc = reader.read(ins);
			Element root = doc.getRootElement();
			List<Element> list = root.elements();
			for (Element e : list) {
				map.put(e.getName(), e.getText());
			}
			return map;
		} catch (DocumentException e) {
			logger.error(e.getMessage(), e);
		} finally {
			try {
				ins.close();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				logger.error(e.getMessage(), e);
			}
		}
		return null;
	}
	
}
