package com.example.afrishop_v3.util;

import com.example.afrishop_v3.models.DcloudDto;
import com.example.afrishop_v3.repository.TbCfExchangeRepository;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.util.List;
import java.util.regex.Pattern;

/**
 * 用于爬虫的数据处理的工具类
 *
 * @author 爱酱油不爱醋
 */
public class SpiderUtil {

    private static BigDecimal rate;
    private static final String DCLOUD_APPID = "H52FE1175";

    static {
        TbCfExchangeRepository tbCfExchangeService = (TbCfExchangeRepository) SpringContextUtil.getBean("tbCfExchangeRepository");
        String exchangeCurrency="CNY";
        rate = tbCfExchangeService.findByExchangeCurrency(exchangeCurrency).getExchangeRate();
        System.out.println(rate);
    }

    /**
     * 转换汇率--由人民币转换为美元
     * 注意：暂时从后台获取人工设置的汇率，还未是动态获取
     * @param fullPrice 原始价格
     * @return 汇率计算的价格
     */
    public static String exchangeRate(String fullPrice) {
        return new BigDecimal(fullPrice).divide(rate, 2, BigDecimal.ROUND_UP).toString();
    }

    /**
     * 去除除了数字之外的所有字符
     *
     * @param str 字符串
     * @return 只有数字的字符串
     */
    public static String retainNumber(String str) {
        str = Pattern.compile("[^0-9]").matcher(str).replaceAll("").trim();
        return str;
    }

    /**
     *
     * @param appid
     * @param start_date
     * @param end_date
     * @param item
     * @param channel
     * @return
     */
    public static List<DcloudDto> spiderByDcloud(String appid, String start_date, String end_date, String item, String channel) throws IOException, URISyntaxException {
        String targetUrl = "https://dev.dcloud.net.cn/statistics/fpat?appid="+ appid + "&start_date=" + start_date + "&end_date=" + end_date + "&item=" + item + "&channel=" + channel;
        String content = HttpClientUtil.getContentByUrl(targetUrl, "Dcloud");
        return null;
    }

    public static void main(String[] args) throws IOException, URISyntaxException {
        String targetUrl = "https://dev.dcloud.net.cn/statistics/fpat?appid=H5014FF11&start_date=2019-12-31&end_date=2020-01-06&item=today_active_user&channel=";
        String content = HttpClientUtil.getContentByUrl(targetUrl, "Dcloud");
        System.out.println(content);
    }
}

