package com.example.afrishop_v3.repository;

import com.example.afrishop_v3.models.TbCfUserInfo;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.PagingAndSortingRepository;

import java.util.List;
import java.util.Optional;

public interface UserRepository extends PagingAndSortingRepository<TbCfUserInfo,String> {
    Optional<TbCfUserInfo> findFirstByAccount(String s);
    boolean existsByAccount(String s);
    boolean existsByPhoneAndUserIdNot(String phone, String userId);
    boolean existsByEmailAndUserIdNot(String phone, String userId);
    Optional<TbCfUserInfo> findByFirebaseUid(String s);
    Optional<TbCfUserInfo> findFirstByFirebaseUidOrAccount(String firebaseUid, String account);
    boolean existsByFirebaseUid(String s);
    Optional<TbCfUserInfo> findFirstByEmail(String s);
    Optional<TbCfUserInfo> findByCode(String s);
    boolean existsByCode(String code);
    List<TbCfUserInfo> findAllByFcmIsNotNullOrderByLastLoginTimeDesc(Pageable pageable);
}
