package com.example.afrishop_v3.repository;

import com.example.afrishop_v3.models.SearchModel;
import com.example.afrishop_v3.models.TbCfStationItem;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface TbCfStationItemRepository extends PagingAndSortingRepository<TbCfStationItem, String> {
    Page<TbCfStationItem> findAllByItemCategorytwo(String category, Pageable pageable);

    Page<TbCfStationItem> findAllByItemDescritionId(String description, Pageable pageable);

    Page<TbCfStationItem> findAllByItemLabelContaining(String label, Pageable pageable);

    @Query(value = "select a from #{#entityName} a WHERE a.itemId <> :itemId and (a.itemDescritionId = :descriptionId or a.itemCategorytwo = :categoryTwo  or a.itemCategory = :category ) order by a.createTime desc ")
    Page<TbCfStationItem> getRecommendItems(@Param("itemId") String itemId, @Param("descriptionId") String descriptionId, @Param("categoryTwo") String categoryTwo, @Param("category") String category, Pageable pageable);

    @Query(value = "select a from #{#entityName} a WHERE a in (SELECT l.item FROM ItemLabel l WHERE l.description IN :tags) and (SELECT count(x.item) FROM ItemLabel x WHERE x.item = a and x.description IN :tags) >= :num ")
    Page<TbCfStationItem> getItemsByImageSearch(@Param("tags") String[] tags, @Param("num") Long num, Pageable pageable);

    @Query(value = "select a from #{#entityName} a order by a.itemTop desc,a.sort asc,a.createTime desc")
    Page<TbCfStationItem> findAllItems(Pageable pageable);

    @Query(value = "select a.item_id as itemId,a.item_code as itemCode,a.item_name as itemName,a.item_brief as itemBrief,a.item_category as itemCategory,a.item_price as itemPrice,a.discount_price as discountPrice,a.item_url as itemUrl,a.item_img as itemImg,a.item_tags as itemTags,a.item_label as itemLabel,a.item_num as itemNum,a.item_collection_num as itemCollectionNum,a.item_count as itemCount,a.item_sku as itemSku,a.item_top as itemTop,a.supplier as supplier,a.platform_code as platformCode,a.platform_name as platformName,a.enable_flag as enableFlag,a.create_time as createTime,a.item_categorytwo as itemCategorytwo,a.item_descrition_id as itemDescritionId,a.sort,a.template,MATCH(a.item_name, a.item_brief) AGAINST(?1 IN NATURAL LANGUAGE MODE) as score from tb_cf_station_item a where a.item_name LIKE CONCAT('%',?1,'%') or a.item_name SOUNDS LIKE ?1 or MATCH(a.item_name, a.item_brief) AGAINST(?1 IN NATURAL LANGUAGE MODE) ORDER BY IF(a.item_name LIKE CONCAT('%',?1,'%'),10000,IF(a.item_name SOUNDS LIKE ?1,9999,score)) desc,a.create_time DESC limit ?2,?3", nativeQuery = true)
    List<SearchModel> searchAllItems(@Param("name") String name, int num, int limit);

    @Query(value = "select count(*),MATCH(a.item_name, a.item_brief) AGAINST(?1 IN NATURAL LANGUAGE MODE) as score from tb_cf_station_item a where a.item_name LIKE CONCAT('%',?1,'%') or a.item_name SOUNDS LIKE ?1 or MATCH(a.item_name, a.item_brief) AGAINST(?1 IN NATURAL LANGUAGE MODE) ", nativeQuery = true)
    Long countAllBySearchItems(String name);

    Page<TbCfStationItem> findAllByItemNameContainingOrItemTagsContaining(String itemName, String itemTags, Pageable pageable);

    Page<TbCfStationItem> findByItemCategory(String itemName, Pageable pageable);

    List<TbCfStationItem> findAllByItemDescritionId(String id, Sort sort);

    @Query(value = "select i from #{#entityName} i inner join AdvertisementItem a on i.itemId=a.itemId where a.adId=?1 order by a.sort")
    Page<TbCfStationItem> getAdvertisementItem(String adId, Pageable pageable);

    @Query(value = "select i from #{#entityName} i inner join AdvertisementItem a on i.itemId=a.itemId where a.adId=?1")
    Page<TbCfStationItem> getAdvertisementItem2(String adId, Pageable pageable);

    List<TbCfStationItem> findTop4ByItemCategoryOrderByCreateTime(String category);

    List<TbCfStationItem> findAllByItemIdIn(String[] ids);

    @Query(value = "select i from #{#entityName} i where i.handled is null ")
    List<TbCfStationItem> queryItemsAll();

    @Modifying
    @Query(value = "update TbCfStationItem set handled='Y',itemImg=:itemImg where itemId=:itemId")
    @Transactional
    int updateItmeImg(@Param("itemImg") String itemImg, @Param("itemId") String itemId);

}
