package com.example.afrishop_v3.repository;

import com.example.afrishop_v3.models.TbCfSearch;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Optional;

public interface TbCfSearchRepository extends PagingAndSortingRepository<TbCfSearch,String> {
    List<TbCfSearch> getAllByUserIdOrderByCreateTimeDesc(String userId);

    @Transactional
    void deleteAllByUserId(String userId);

    Optional<TbCfSearch> findFirstBySearchKeywordsAndUserId(String searchKeywords, String userId);

    @Transactional
    void deleteAllByIdInAndUserId(String[] ids,String userId);
}
