package com.example.afrishop_v3.models;

import lombok.Data;

import javax.persistence.Entity;
import javax.persistence.Id;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 财务明细实体
 * 表名 tb_cf_finance
 *
 * @author G
 * @date 2019-08-14 09:11:48
 */
@Entity
@Data
public class TbCfFinance{

    /**
     * 财务报表id
     */
    @Id
    private String finaceId;
    /**
     * 订单id
     */
    private String orderId;
    /**
     * 用户id
     */
    private String userId;
    /**
     * 支付款项
     */
    private BigDecimal payAccount;
    /**
     * 支付流水号
     */
    private String payId;
    /**
     * 支付方式
     */
    private String payWayCode;
    /**
     * 支付时间
     */
    private Date payTime;
    /**
     * 支付结果页面
     */
    private String receiptUrl;

    /**
     * 设置：财务报表id
     */
    public void setFinaceId(String finaceId) {
        this.finaceId = finaceId;
    }

    /**
     * 获取：财务报表id
     */
    public String getFinaceId() {
        return finaceId;
    }
    /**
     * 设置：订单id
     */
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    /**
     * 获取：订单id
     */
    public String getOrderId() {
        return orderId;
    }
    /**
     * 设置：用户id
     */
    public void setUserId(String userId) {
        this.userId = userId;
    }

    /**
     * 获取：用户id
     */
    public String getUserId() {
        return userId;
    }
    /**
     * 设置：支付款项
     */
    public void setPayAccount(BigDecimal payAccount) {
        this.payAccount = payAccount;
    }

    /**
     * 获取：支付款项
     */
    public BigDecimal getPayAccount() {
        return payAccount;
    }
    /**
     * 设置：支付流水号
     */
    public void setPayId(String payId) {
        this.payId = payId;
    }

    /**
     * 获取：支付流水号
     */
    public String getPayId() {
        return payId;
    }
    /**
     * 设置：支付方式
     */
    public void setPayWayCode(String payWayCode) {
        this.payWayCode = payWayCode;
    }

    /**
     * 获取：支付方式
     */
    public String getPayWayCode() {
        return payWayCode;
    }
    /**
     * 设置：支付时间
     */
    public void setPayTime(Date payTime) {
        this.payTime = payTime;
    }

    /**
     * 获取：支付时间
     */
    public Date getPayTime() {
        return payTime;
    }

    public String getReceiptUrl() {
        return receiptUrl;
    }

    public void setReceiptUrl(String receiptUrl) {
        this.receiptUrl = receiptUrl;
    }
}
