package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.enums.ResultCodeEnum;
import com.example.afrishop_v3.models.TbCfItemComment;
import com.example.afrishop_v3.models.TbCfItemLike;
import com.example.afrishop_v3.models.TbCfUserInfo;
import com.example.afrishop_v3.repository.TbCfItemCommentRepository;
import com.example.afrishop_v3.repository.TbCfItemLikeRepository;
import com.example.afrishop_v3.security.services.AuthenticationUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.*;

import java.util.Optional;

@RestController
@RequestMapping("item_like")
public class ItemLikeController {
    private final TbCfItemLikeRepository repository;
    private final TbCfItemCommentRepository commentRepository;
    private final AuthenticationUser user;
    private static Logger logger = LoggerFactory.getLogger(ItemLikeController.class);

    public ItemLikeController(TbCfItemLikeRepository repository, TbCfItemCommentRepository commentRepository, AuthenticationUser user) {
        this.repository = repository;
        this.commentRepository = commentRepository;
        this.user = user;
    }

    //Like comment
    @PutMapping("like/{comment_id}")
    public Result likeComment(@PathVariable("comment_id") String commentId ){
      try {
          Optional<TbCfItemComment> commentOptional = commentRepository.findById(commentId);
          //Check if comment exists
          if( !commentOptional.isPresent() ) {
              logger.warn("Item Comment not found !");
              logger.warn(commentId);
              return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(), "Item comment not found !");
          }
          TbCfUserInfo user = this.user.user();
          String userId = user.getUserId();
          //Check if comment is already liked
          boolean exists = repository.existsByCommentIdAndUserUserId(commentId, userId);

          if( exists ){
              repository.deleteAllByCommentIdAndUserUserId(commentId,userId);
              return new Result<>(false,"Comment disliked");
          }

          TbCfItemLike itemLike = new TbCfItemLike();

          itemLike.setUser(user);
          itemLike.setComment(commentOptional.get());

          repository.save(itemLike);
      }catch (Exception e){
          System.out.println(e.getMessage());
          logger.debug(e.getMessage());
          logger.warn(e.toString());
      }

        return new Result<>(true,"Comment liked");
    }
}
