package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.enums.ResultCodeEnum;
import com.example.afrishop_v3.models.TbCfToicoupon;
import com.example.afrishop_v3.repository.TbCfCouponRepository;
import com.example.afrishop_v3.repository.TbCfToicouponRepository;
import com.example.afrishop_v3.security.services.AuthenticationUser;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.*;

@RestController
@RequestMapping("/coupon")
public class CouponController {
    private final TbCfToicouponRepository repository;
    private final AuthenticationUser user;

    public CouponController(TbCfToicouponRepository repository, AuthenticationUser user) {
        this.repository = repository;
        this.user = user;
    }

    //Get coupons list by authenticated user
    @GetMapping
    public Result getUserCoupons() {
        Optional<String> userOptional = Optional.ofNullable(user.userId());
        if (userOptional.isPresent()) {
            return queryCouponByUserId(user.userId());
        }
        return null;
    }


    @GetMapping("queryCouponByUserId")
    public Result queryCouponByUserId(@RequestParam("userId") String userId) {
        List<TbCfToicoupon> availableCoupons = repository.queryUserAvailableCoupon(userId);
        List<TbCfToicoupon> expiredCoupons = repository.queryUserExpiredCoupon(userId);
        List<TbCfToicoupon> usedCoupons = repository.queryUserUsedCoupon(userId);

        LinkedHashMap<String, Object> hashMap = new LinkedHashMap<>();

        hashMap.put("validCouponList", availableCoupons);
        hashMap.put("usedCouponList", usedCoupons);
        hashMap.put("expiredCouponList", expiredCoupons);

        return new Result<>(hashMap);
    }

    //Find single coupon by coupon id
    @GetMapping("{couponId}")
    public Result queryCouponDetails(@PathVariable("couponId") String couponId) {

        return new Result<>(repository.findById(couponId));
    }


    @GetMapping("take/{couponId}")
    public Result couponTake(@PathVariable("couponId") String couponId) {
        // TODO
        //TbCfCouponEntity tbCfCouponEntity=grabCoupon(couponId);
//        if(tbCfCouponEntity!=null) {
//            //发放优惠券
//            //giveOutCoupon(tbCfUserInfoVo.getUserId(),tbCfCouponEntity);
//            //result.setData(tbCfCouponEntity);
//            //result.setMessage("Successfully received");
//        } else {
//        }
        return new Result(ResultCodeEnum.ERROR.getCode(), "The coupon has been snapped up");
    }

//    /**
//     * 查询用户未使用的优惠券,可用的排在顶部
//     */
//    @GetMapping("/selectCoupon")
//    public Result queryUserAvailableCoupons(@RequestParam("orderPrice") BigDecimal orderPrice) {
//        Map<String, Object> couponMap = new HashMap<>();
//        //可使用的优惠券
//        LinkedList<TbCfToicoupon> availableCoupon = new LinkedList();
//        //不可使用的优惠券
//        LinkedList<TbCfToicoupon> unAvailableCoupon = new LinkedList();
//        List<TbCfToicoupon> couponList = repository.queryUserAvailableCoupon(user.userId());
//        couponList.forEach(coupon -> {
//            boolean available = orderPrice.compareTo(coupon.withAmount()) >= 0;
//            if (available) {
//                availableCoupon.add(coupon);
//            } else {
//                unAvailableCoupon.add(coupon);
//            }
//        });
//        couponMap.put("availableCoupon", availableCoupon);
//        couponMap.put("unAvailableCoupon", unAvailableCoupon);
//
//        return new Result(couponMap);
//    }
}
