package com.example.afrishop_v3.repository;

import com.example.afrishop_v3.inter_face.OrderCount;
import com.example.afrishop_v3.models.TbCfItemOrderR;
import com.example.afrishop_v3.models.TbCfOrder;
import com.example.afrishop_v3.models.TbCfUserInfo;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

public interface TbCfOrderRepository extends PagingAndSortingRepository<TbCfOrder,String> {
    @Query("select a as order, count(x) as commented from #{#entityName} a left join TbCfItemComment x on a.orderId=x.orderId and x.user=:user where a.userId=:userId group by a")
    Page<OrderCount> findAllByUserId(@Param("userId") String userId, @Param("user") TbCfUserInfo user, Pageable pageable);
    @Query("select a as order, count(x) as commented from #{#entityName} a left join TbCfItemComment x on a.orderId=x.orderId and x.user=:user where a.userId=:userId and a.orderStatus=:status group by a")
    Page<OrderCount> findAllByUserIdWithStatus(@Param("userId") String userId, @Param("user") TbCfUserInfo user,@Param("status") Integer orderStatus, Pageable pageable);
//    @Query(value = "select a from #{#entityName} a where :now >  DATE_SUB(a.orderTime,interval -1 day) and order_status=10")
//    List<TbCfOrder> getTimeoutOrders(@Param("now") Date date);

    List<TbCfOrder> findAllByOrderTimeLessThanAndOrderStatus(Date orderTime, Integer orderStatus);


    @Modifying
    @Query(value = "update tb_cf_item_skus sk INNER JOIN tb_cf_item_order_r r ON r.item_sku_id=sk.id set sk.sku_count=sk.sku_count+r.item_num WHERE r.order_id = :orderId ",nativeQuery = true)
    void returnSkuQuantity(@Param("orderId") String orderId);

    @Modifying
    @Query(value = "update tb_cf_station_item sk INNER JOIN tb_cf_item_order_r r ON r.item_id=sk.item_id set sk.item_count=sk.item_count+r.item_num WHERE r.order_id = :orderId ",nativeQuery = true)
    void returnItemQuantity(@Param("orderId") String orderId);

    @Query(value = "SELECT t1.*,t2.order_item_id ordersId,t2.order_status orderStatus,t2.item_num itemNum FROM tb_cf_item_detail t1 LEFT JOIN tb_cf_item_order_r t2 ON t1.item_id = t2.item_id LEFT JOIN tb_cf_order t3 ON t2.order_id = t3.order_id WHERE t2.enable_flag = 1 AND t2.order_id =:orderId",nativeQuery = true)
    List getAllByItemList(String orderId);


}
