package com.example.afrishop_v3.repository;

import com.example.afrishop_v3.models.Hashtag;
import com.example.afrishop_v3.models.Post;
import com.example.afrishop_v3.models.TbCfUserInfo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.query.Param;

public interface PostRepository extends PagingAndSortingRepository<Post, String> {
    Page<Post> findAllByUserInfoUserIdOrderByCreateDateDesc(String tUser_userId, Pageable pageable);
    Page<Post> findAllByDescriptionContainingOrTitleContainingOrUserInfoNickContaining(String query, String query1, String query2, Pageable pageable);
    @Query(value = "select a from #{#entityName} a WHERE a.userInfo = :me OR EXISTS(SELECT f.followerInfo FROM Following f WHERE f.followerInfo=:me and f.followedInfo=a.userInfo)  order by a.createDate desc")
    Page<Post> findAllByOrderByIdDesc(@Param("me") TbCfUserInfo user, Pageable pageable);
    @Query(value = "select a from #{#entityName} a WHERE a IN (SELECT x.post FROM PostLike x WHERE x.userInfo=:me) order by a.createDate desc")
    Page<Post> findAllByOrderByCreateDateDesc(@Param("me") TbCfUserInfo user, Pageable pageable);
    @Query(value = "select a from #{#entityName} a WHERE a IN (SELECT x.post FROM PostHashtag x WHERE x.hashtag=:tag) order by a.createDate desc")
    Page<Post> findAllByOrderByCreateDateDesc(@Param("tag") Hashtag hashtag, Pageable pageable);
    Page<Post> findAllByOrderByCreateDateDesc(Pageable pageable);
    //@Query(value = "select a from #{#entityName} a WHERE NOT EXISTS(SELECT f.follower FROM Following f WHERE f.follower=:me and f.followed=a.user)")
    //Page<Post> _findAllByOrderByIdDesc(@Param("me") User user,Pageable pageable);
    //Page<Post> _findAllByOrderByIdDesc(Pageable pageable);

}
