package com.example.afrishop_v3.repository;

import com.example.afrishop_v3.models.Hashtag;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.PagingAndSortingRepository;

import java.util.Optional;

public interface HashtagRepository extends PagingAndSortingRepository<Hashtag,String> {
    boolean existsByName(String name);
    Optional<Hashtag> findFirstByName(String name);

    Page<Hashtag> findAllByNameContaining(String name, Pageable pageable);
}
