package com.example.afrishop_v3.models;

import com.alibaba.fastjson.JSONObject;
import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.base.StateConstant;
import com.example.afrishop_v3.enums.OrderStatusEnum;
import com.example.afrishop_v3.enums.ResultCodeEnum;
import com.example.afrishop_v3.repository.ActivityRepository;
import com.example.afrishop_v3.repository.TbCfStationItemRepository;
import com.example.afrishop_v3.util.IdUtil;
import com.example.afrishop_v3.vo.Condition;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import net.sf.json.JSONArray;
import org.hibernate.annotations.Where;
import org.springframework.data.relational.core.sql.In;
import org.springframework.web.bind.annotation.PathVariable;

import javax.persistence.*;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 订单表实体
 * 表名 tb_cf_order
 *
 * @author lipengjun
 * @date 2020-04-24 15:51:42
 */
@Entity
@Data
@Table(name = "tb_cf_order")
@Where(clause = "enable_flag = 1")
public class TbCfOrder {

    /**
     * 订单id
     */
    @Id
    private String orderId;
    /**
     * 订单号
     */
    private String orderNo;
    /**
     * 订单名
     */
    private String orderName;
    /**
     * 订单创建时间
     */

    private Date orderTime;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 订单来源 1:app 2:pc
     */
    private Integer orderSource;
    /**
     * 成交时间
     */
    private Date dealTime;
    /**
     * 交易关闭时间
     */
    private Date closeTime;
    /**
     * 订单状态(0删除，10未付款，20已付款，40已发货，50交易成功，60交易关闭)
     */
    private Integer orderStatus;
    /**
     * 用户id
     */
    private String userId;
    /**
     * 用户名
     */
    private String userName;
    /**
     * 收货地址Id
     */
    private String deliveryAddressId;
    /**
     * 收货地址
     */
    private String deliveryAddress;
    /**
     * 收货人
     */
    private String deliveryName;
    /**
     * 收货人手机
     */
    private String deliveryPhone;
    /**
     * 商品总价
     */
    private BigDecimal itemsPrice;
    /**
     * 总价
     */
    private BigDecimal totalPrice;
    /**
     * 实际付款
     */
    private BigDecimal realityPay;
    /**
     * 发货标志、代购标志
     */
    private Integer deliveryFlag;
    /**
     * 发货时间
     */
    private Date deliveryTime;
    /**
     * 快递费
     */
    private BigDecimal expressCost;
    /**
     * 活动id
     */
    private String activityId;
    /**
     * 优惠券id
     */
    private String couponId;
    /**
     * 优惠券标题
     */
    private String couponTitle;
    /**
     * 优惠券减免价格
     */
    private BigDecimal couponPrice;
    /**
     * 税费
     */
    private BigDecimal tax;
    /**
     * 手续费
     */
    private BigDecimal fee;
    /**
     * 交易号
     */
    private String payId;
    /**
     * 支付状态，10未支付，20已支付
     */
    private Integer payStatus;
    /**
     * 删除标志 1未删除 0删除
     */
    private Integer enableFlag;
    /**
     * 商品品名(废弃)
     */
    private String descripitionName;
    /**
     * 订单关闭原因
     */
    private String remarkInfo;


    private BigDecimal reduceAmount = new BigDecimal("0.0");

    @Transient
    private Map<String, Object> couponMap;


    @Transient
    private boolean open = false;

    @Transient
    private boolean hasActivity;

    public Map<String, Object> getCouponMap() {
        return couponMap;
    }

    public void setCouponMap(Map<String, Object> couponMap) {
        this.couponMap = couponMap;
    }

    //    @JsonIgnore
//    @JoinColumn(columnDefinition = "user_id",name = "user_id")
//    @ManyToOne(fetch = FetchType.LAZY)
//    private TbCfUserInfo userInfo;

    @Transient
    private TbCfExpressTemplate defaultTemplate;

    @Transient
    private Integer commentCount;

    @Transient
    private BigDecimal rate;

    @Transient
    private String expiration;

    public TbCfOrder() {
        this.orderStatus = OrderStatusEnum.PENDING_PAY.getValue();
        this.enableFlag = StateConstant.VALID;
        this.payStatus = OrderStatusEnum.PENDING_PAY.getValue();
        this.orderTime = new Date();
    }

    public BigDecimal getReduceAmount() {
        return this.reduceAmount == null ? new BigDecimal("0.0") : reduceAmount.setScale(2, BigDecimal.ROUND_HALF_UP);

    }

    public void setReduceAmount(BigDecimal reduceAmount) {
        this.reduceAmount = reduceAmount;
    }

    public void setCommentCount(Integer commentCount) {
        this.commentCount = commentCount;
    }

    @OneToMany(mappedBy = "orderId", cascade = CascadeType.ALL, fetch = FetchType.EAGER)
    private List<TbCfItemOrderR> itemOrderList = new ArrayList<>();


    public void setExpiration(String expiration) {
        this.expiration = expiration;
    }

    /**
     * 设置：订单id
     */
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    /**
     * 获取：订单id
     */
    public String getOrderId() {
        return orderId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    /**
     * 设置：订单名
     */
    public void setOrderName(String orderName) {
        this.orderName = orderName;
    }


    public List<TbCfItemOrderR> getItemOrderList() {
        return itemOrderList;
    }

    public void getItemOrderListFromCartList(List<TbCfCartRecordR> cartList, TbCfStationItemRepository itemRepository, ActivityRepository activityRepository) throws ParseException {
        itemOrderList = cartList.stream().map(f -> f.getOrderItem(orderId)).collect(Collectors.toList());
        doSomeCalculations(itemRepository, activityRepository);
        setOrderTime(new Date());
        setDealTime(new Date());
        setOrderNo(String.valueOf(IdUtil.createLongIdByDate()));
    }


    public void setDefaultTemplate(TbCfExpressTemplate defaultTemplate) {
        this.defaultTemplate = defaultTemplate;
    }

    private void doSomeCalculations(TbCfStationItemRepository itemRepository, ActivityRepository activityRepository) throws ParseException {
        itemsPrice = itemsPrice == null ? new BigDecimal(0.0) : itemsPrice;
        expressCost = expressCost == null ? new BigDecimal(0.0) : expressCost;
        fee = fee == null ? new BigDecimal(0.0) : fee;
        tax = tax == null ? new BigDecimal(0.0) : tax;
        reduceAmount = reduceAmount == null ? new BigDecimal(0.0) : reduceAmount;
        List<TemplateVo> templateList = new ArrayList<>();
//        List<ActivityVo> activityList = new ArrayList<>();

        itemOrderList.forEach(item -> {
            BigDecimal itemPrice = item.getItemPriceTotal();
            TbCfExpressTemplate template = item.getTemplate();
//            if (template != null) {
//                System.out.println(template.getHandlingFee());
//                System.out.println(template.getTariff());
//            }

            Optional<TbCfStationItem> optionalTbCfStationItem = itemRepository.findById(item.getItemId());
            boolean categoriesAct = activityRepository.existsByUseType(2);
            boolean specialAct = activityRepository.existsByUseType(3);
//            Activity activity = new Activity();
//            if (categoriesAct || specialAct) {
//                try {
//                    activity = getItemActivity(activityRepository, itemRepository, item.getItemId());
//                } catch (ParseException e) {
//                    e.printStackTrace();
//                }
//
//                activityList.add(new ActivityVo(activity, activity.getId(), item.getItemNum(), itemPrice));
//            }
            if (optionalTbCfStationItem.isPresent()) {
                TbCfStationItem stationItem = optionalTbCfStationItem.get();
                if (stationItem.getExpress() != null) {
                    template = stationItem.getExpress();
                }
            }

            template = template == null ? defaultTemplate : template;
            itemsPrice = itemsPrice.add(itemPrice);
            tax = tax.add(calculateDutyFee(itemPrice, template));
            fee = fee.add(calculateHandlingFee(itemPrice, template));
            if (template != null)
                templateList.add(new TemplateVo(template, template.getTemplateId(), item.getItemNum(), itemPrice));
        });
        Map<String, List<TemplateVo>> map = templateList.stream().collect(Collectors.groupingBy(TemplateVo::getTemplateId));
//        Map<String, List<ActivityVo>> actMap = activityList.stream().collect(Collectors.groupingBy(ActivityVo::getActivityId));

        //按模板分组计算商品价格
        Integer itemSum = 0;
        List<TemplateVo> list = new ArrayList<>();
        for (String key : map.keySet()) {
            TemplateVo templateVo = new TemplateVo();
            TbCfExpressTemplate _template = null;
            Integer count = 0;
            BigDecimal totalPrice = BigDecimal.ZERO;
            for (TemplateVo template : map.get(key)) {
                totalPrice = totalPrice.add(template.getItemPrice());
                count += template.getItemCount();
                itemSum += template.getItemCount();
                _template = template.getTemplate();
            }
            templateVo.setTemplateId(key);
            templateVo.setItemCount(count);
            templateVo.setItemPrice(totalPrice);
            templateVo.setTemplate(_template);
            list.add(templateVo);
        }
        for (TemplateVo t : list) {
            System.err.println(t);
            //1.判断是否包邮4
            //免邮价格
            TbCfExpressTemplate express = t.getTemplate();

            //if( express == null ) continue;

            BigDecimal freePrice = express.getPostageFreePrice();
            boolean b = t.getItemPrice().compareTo(freePrice) >= 0 ? true : false;
            if (b) {
                //包邮
                expressCost = expressCost.add(BigDecimal.ZERO);
            } else {
                //按运费模板计算
                //续件
                int extralNum = t.getItemCount() - express.getStartNum();
                expressCost = expressCost.add(express.getExpressFee().add(express.getContinuationFee().multiply(new BigDecimal(extralNum))));
            }
        }
        System.out.println("活动是否开启：" + this.open);
        /**
         * 活动模块：活动类型 1：满减 2：满折 3：满件打折（type）
         *          使用类型 1：全场 2：分类商品 3：特定商品（use_type）
         */
        boolean fullAct = activityRepository.existsByUseType(1);
        /**
         * 之前app没有接活动，所以要和mobile端区分，才设置一个开关（open）
         */
        if (/*this.open && */fullAct) {

            Activity act = null;
            List<Activity> alist = activityRepository.findAllByUseType(1);
            if (alist != null && alist.size() > 0) {
                act = alist.get(0);
            }
            Optional<Activity> optional = Optional.ofNullable(act);
            if (optional.isPresent()) {
                Activity activity = optional.get();
                String type = String.valueOf(activity.getType());
                if ("1".equals(type)) {
                    reduceAmount = caculateActFee(false, false, activity, itemsPrice, null);
                    System.out.println("减免金额：$" + reduceAmount);
                } else if ("2".equals(type)) {
                    rate = caculateActFee(false, true, activity, itemsPrice, null);
                    System.out.println("折扣比例：" + rate.multiply(new BigDecimal(100)) + "折");
//                itemsPrice = rate.multiply(itemsPrice);
                    reduceAmount = itemsPrice.multiply(rate);
                } else if ("3".equals(type)) {
                    rate = caculateActFee(true, true, activity, itemsPrice, itemSum);
                    System.out.println("购买件数：" + itemSum);
                    System.out.println("折扣比例：" + rate.multiply(new BigDecimal(100)) + "折");
//                itemsPrice = rate.multiply(itemsPrice);
                    reduceAmount = itemsPrice.multiply(rate);
                }
                reduceAmount = reduceAmount.setScale(2, BigDecimal.ROUND_HALF_UP);
                System.out.println("折扣金额：" + reduceAmount);
            }

        } /*else {
            //按活动类型计算优惠价格
            Integer sum = 0;
            List<ActivityVo> actlist = new ArrayList<>();
            for (String key : actMap.keySet()) {
                Activity activity = null;
                ActivityVo activityVo = new ActivityVo();
                Integer count = 0;
                BigDecimal totalPrice = BigDecimal.ZERO;
                for (ActivityVo act : actMap.get(key)) {
                    totalPrice = totalPrice.add(act.getItemPrice());
                    count += act.getItemNum();
                    sum += act.getItemNum();
                    activity = act.getActivity();
                }
                activityVo.setActivity(activity);
                activityVo.setActivityId(key);
                activityVo.setItemNum(count);
                activityVo.setItemPrice(totalPrice);
                actlist.add(activityVo);
            }

            actlist.forEach(act -> {
                while (act.getActivityId() == null) {
                    continue;
                }
                if ("1".equals(act.getActivity().getUseType())) {
                    reduceAmount = caculateActFee(false, false, act.getActivity(), act.getItemPrice(), null);
                    System.out.println("减免金额：" + reduceAmount);
                } else if ("2".equals(act.getActivity().getUseType())) {
                    rate = caculateActFee(false, true, act.getActivity(), act.getItemPrice(), null);
                    System.out.println("折扣比例：" + rate);
                    itemsPrice = rate.multiply(itemsPrice);
                } else if ("3".equals(act.getActivity().getUseType())) {
                    rate = caculateActFee(true, true, act.getActivity(), act.getItemPrice(), act.getItemNum());
                    System.out.println("购买件数：" + act.getItemNum());
                    System.out.println("折扣比例：" + rate);
                    itemsPrice = rate.multiply(itemsPrice);
                }
            });
        }*/

        totalPrice = itemsPrice.add(fee).add(tax).add(expressCost).subtract(reduceAmount);

        countRealityPay();
    }

    public BigDecimal caculateActFee(Boolean isCount, Boolean discount, Activity activity, BigDecimal itemsPrice, Integer itemCount) {

        List<Condition> conList = JSONObject.parseArray(activity.getCondition(), Condition.class);
        Collections.sort(conList, Comparator.comparing(Condition::getKey));
        System.out.println(conList);
        BigDecimal result = new BigDecimal("0.0");

        for (int i = 0; i < conList.size(); i++) {
            if (isCount) {
                if (itemCount >= conList.get(i).getKey()) {
                    result = new BigDecimal(conList.get(i).getValue());
                }
            } else {
                if (itemsPrice.compareTo(new BigDecimal(conList.get(i).getKey())) >= 0) {
                    result = new BigDecimal(conList.get(i).getValue());
                }
            }
        }
        if (discount) {
            result = result.divide(new BigDecimal(100));
        }

        return result;
    }


    @Transient
    private TbCfCoupon coupon;

    public void setCoupon(TbCfCoupon coupon) {
        this.coupon = coupon;
    }

    private void countRealityPay() {
        if (coupon != null) {
            setCouponPrice(coupon.getDeductAmount());
            // setCouponId(coupon.getCouponId());
        }
        BigDecimal couponPrice = this.getCouponPrice();
        //实际需要支付款项
        if (couponPrice != null) {
            BigDecimal realityPay = this.getTotalPrice().subtract(couponPrice);
            //比0小则等于0
            if (realityPay.compareTo(BigDecimal.ZERO) < 0) {
                realityPay = BigDecimal.ZERO;
            }
            setRealityPay(realityPay);
        } else {
            setRealityPay(getTotalPrice());
        }
    }


    @Transient
    private List<String> usedList = new ArrayList<>();


    private BigDecimal calculateHandlingFee(BigDecimal itemPrice, TbCfExpressTemplate expressTemplate) {
        if (expressTemplate == null) return BigDecimal.ZERO;
        //计算手续费
        //计算手续费

        return expressTemplate.getHandlingFee()
                .multiply(itemPrice);

    }


    private BigDecimal calculateExpressCost(TbCfCartRecordR record, TbCfExpressTemplate express) {
        BigDecimal decimal = new BigDecimal(0.0);

        if (usedList.stream().anyMatch(f -> f.equals(express.getTemplateId()))) {
            return decimal;
        }

        usedList.add(express.getTemplateId());

        //计算手续费
        BigDecimal freePrice = express.getPostageFreePrice();
        boolean b = record.getItemPrice().compareTo(freePrice) > 0;
        if (b) {
            //包邮
            return decimal.add(BigDecimal.ZERO);
        } else {
            int extralNum = record.getItemNum() - express.getStartNum();
            return decimal.add(express.getExpressFee().add(express.getContinuationFee().multiply(new BigDecimal(extralNum))));
        }

    }

    private BigDecimal calculateDutyFee(BigDecimal itemPrice, TbCfExpressTemplate expressTemplate) {
        if (expressTemplate == null) return BigDecimal.ZERO;
        //计算关税


        return expressTemplate.getTariff().multiply(itemPrice);

    }


    /**
     * 获取：订单名
     */
    public String getOrderName() {
        return orderName;
    }

    /**
     * 设置：订单创建时间
     */
    public void setOrderTime(Date orderTime) {
        this.orderTime = orderTime;
    }

    /**
     * 获取：订单创建时间
     */
    //@JsonProperty(value = "date")
    public Date getOrderTime() {
        return orderTime;
    }
    /**
     * 获取：订单创建时间
     */
//
//    static SimpleDateFormat format = new SimpleDateFormat("yyyy-MMM-dd HH:mm:ss");
//
//    @JsonProperty(value = "orderTime")
//    public String getOrderTimeFormatted() {
//        return format.format(getOrderTime());
//    }

    /**
     * 设置：更新时间
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 获取：更新时间
     */
    public Date getUpdateTime() {
        return updateTime;
    }

    /**
     * 设置：订单来源 1:app 2:pc
     */
    public void setOrderSource(Integer orderSource) {
        this.orderSource = orderSource;
    }

    /**
     * 获取：订单来源 1:app 2:pc
     */
    public Integer getOrderSource() {
        return orderSource;
    }

    /**
     * 设置：成交时间
     */
    public void setDealTime(Date dealTime) {
        this.dealTime = dealTime;
    }

    /**
     * 获取：成交时间
     */
    public Date getDealTime() {
        return dealTime;
    }

    /**
     * 设置：交易关闭时间
     */
    public void setCloseTime(Date closeTime) {
        this.closeTime = closeTime;
    }

    /**
     * 获取：交易关闭时间
     */
    public Date getCloseTime() {
        return closeTime;
    }

    /**
     * 设置：订单状态(0删除，10未付款，20已付款，40已发货，50交易成功，60交易关闭)
     */
    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
        setItemStatuses(orderStatus);
    }

    private void setItemStatuses(Integer orderStatus) {
        itemOrderList.forEach(f -> f.setOrderStatus(orderStatus));
    }

    /**
     * 获取：订单状态(0删除，10未付款，20已付款，40已发货，50交易成功，60交易关闭)
     */
    public Integer getOrderStatus() {
        return orderStatus;
    }

    /**
     * 设置：用户id
     */
    public void setUserId(String userId) {
        this.userId = userId;
    }

    /**
     * 获取：用户id
     */
    public String getUserId() {
        return userId;
    }

    /**
     * 设置：用户名
     */
    public void setUserName(String userName) {
        this.userName = userName;
    }

    /**
     * 获取：用户名
     */
    public String getUserName() {
        return userName;
    }

    /**
     * 设置：收货地址Id
     */
    public void setDeliveryAddressId(String deliveryAddressId) {
        this.deliveryAddressId = deliveryAddressId;
    }

    /**
     * 获取：收货地址Id
     */
    public String getDeliveryAddressId() {
        return deliveryAddressId;
    }

    /**
     * 设置：收货地址
     */
    public void setDeliveryAddress(String deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    /**
     * 获取：收货地址
     */
    public String getDeliveryAddress() {
        return deliveryAddress;
    }

    /**
     * 设置：收货人
     */
    public void setDeliveryName(String deliveryName) {
        this.deliveryName = deliveryName;
    }

    /**
     * 获取：收货人
     */
    public String getDeliveryName() {
        return deliveryName;
    }

    /**
     * 设置：收货人手机
     */
    public void setDeliveryPhone(String deliveryPhone) {
        this.deliveryPhone = deliveryPhone;
    }

    /**
     * 获取：收货人手机
     */
    public String getDeliveryPhone() {
        return deliveryPhone;
    }

    /**
     * 设置：商品总价
     */
    public void setItemsPrice(BigDecimal itemsPrice) {
        this.itemsPrice = itemsPrice;
    }

    /**
     * 获取：商品总价
     */
    public BigDecimal getItemsPrice() {
        return itemsPrice == null ? BigDecimal.ZERO : itemsPrice.setScale(2, RoundingMode.HALF_UP);
    }

    /**
     * 设置：总价
     */
    public void setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }

    /**
     * 获取：总价
     */
    public BigDecimal getTotalPrice() {
        return totalPrice == null ? BigDecimal.ZERO : totalPrice.setScale(2, RoundingMode.HALF_UP);
    }

    /**
     * 设置：实际付款
     */
    public void setRealityPay(BigDecimal realityPay) {
        this.realityPay = realityPay;
    }

    /**
     * 获取：实际付款
     */
    public BigDecimal getRealityPay() {
        return realityPay == null ? BigDecimal.ZERO : realityPay.setScale(2, RoundingMode.HALF_UP);
    }

    /**
     * 设置：发货标志、代购标志
     */
    public void setDeliveryFlag(Integer deliveryFlag) {
        this.deliveryFlag = deliveryFlag;
        setDeliveryFlagForItems(deliveryFlag);
    }

    private void setDeliveryFlagForItems(Integer deliveryFlag) {
        itemOrderList.forEach(f -> f.setDeliveryFlag(deliveryFlag));
    }

    /**
     * 获取：发货标志、代购标志
     */
    public Integer getDeliveryFlag() {
        return deliveryFlag;
    }

    /**
     * 设置：发货时间
     */
    public void setDeliveryTime(Date deliveryTime) {
        this.deliveryTime = deliveryTime;
    }

    /**
     * 获取：发货时间
     */
    public Date getDeliveryTime() {
        return deliveryTime;
    }

    /**
     * 设置：快递费
     */
    public void setExpressCost(BigDecimal expressCost) {
        this.expressCost = expressCost;
    }

    /**
     * 获取：快递费
     */
    public BigDecimal getExpressCost() {
        return expressCost == null ? BigDecimal.ZERO : expressCost.setScale(2, RoundingMode.HALF_UP);
    }

    /**
     * 设置：优惠券id
     */
    public void setCouponId(String couponId) {
        this.couponId = couponId;
    }


    public void setOpen(boolean open) {
        this.open = open;
    }

    /**
     * 获取：优惠券id
     */
    public String getCouponId() {
        return couponId;
    }

    /**
     * 设置：优惠券标题
     */
    public void setCouponTitle(String couponTitle) {
        this.couponTitle = couponTitle;
    }

    /**
     * 获取：优惠券标题
     */
    public String getCouponTitle() {
        return couponTitle;
    }

    /**
     * 设置：优惠券减免价格
     */
    public void setCouponPrice(BigDecimal couponPrice) {
        this.couponPrice = couponPrice;
    }

    /**
     * 获取：优惠券减免价格
     */
    public BigDecimal getCouponPrice() {
        return couponPrice;
    }

    /**
     * 设置：税费
     */
    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    /**
     * 获取：税费
     */
    public BigDecimal getTax() {
        return tax == null ? BigDecimal.ZERO : tax.setScale(2, BigDecimal.ROUND_HALF_UP);
    }

    /**
     * 设置：手续费
     */
    public void setFee(BigDecimal fee) {
        this.fee = fee;
    }

    /**
     * 获取：手续费
     */
    public BigDecimal getFee() {
        return fee == null ? BigDecimal.ZERO : fee.setScale(2, BigDecimal.ROUND_HALF_UP);
    }

    /**
     * 设置：交易号
     */
    public void setPayId(String payId) {
        this.payId = payId;
    }

    /**
     * 获取：交易号
     */
    public String getPayId() {
        return payId;
    }

    /**
     * 设置：支付状态，10未支付，20已支付
     */
    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    /**
     * 获取：支付状态，10未支付，20已支付
     */
    public Integer getPayStatus() {
        return payStatus;
    }

    /**
     * 设置：删除标志 1未删除 0删除
     */
    public void setEnableFlag(Integer enableFlag) {
        this.enableFlag = enableFlag;
        setEnableFlagForItems(enableFlag);
    }

    private void setEnableFlagForItems(Integer enableFlag) {
        itemOrderList.forEach(f -> f.setEnableFlag(enableFlag));
    }

    /**
     * 获取：删除标志 1未删除 0删除
     */
    public Integer getEnableFlag() {
        return enableFlag;
    }

    /**
     * 设置：商品品名(废弃)
     */
    public void setDescripitionName(String descripitionName) {
        this.descripitionName = descripitionName;
    }

    /**
     * 获取：商品品名(废弃)
     */
    public String getDescripitionName() {
        return descripitionName;
    }

    /**
     * 设置：订单关闭原因
     */
    public void setRemarkInfo(String remarkInfo) {
        this.remarkInfo = remarkInfo;
    }

    /**
     * 获取：订单关闭原因
     */
    public String getRemarkInfo() {
        return remarkInfo;
    }

    public Activity getItemActivity(ActivityRepository activityRepository, TbCfStationItemRepository itemRepository, String itemId) throws ParseException {
        Activity activity = null;
//
        //全场活动
        if (activityRepository.existsByUseType(1)) {
            List<Activity> fullList = activityRepository.findAllByUseType(1);
            activity = fullList.get(0);
        }

        //商品分类活动
        if (activityRepository.existsByUseType(2)) {
            Optional<TbCfStationItem> byId = itemRepository.findById(itemId);
            if (byId.isPresent()) {
                TbCfStationItem item = byId.get();
                String category1 = item.getItemCategory();
                String category2 = item.getItemCategorytwo();
                String category3 = item.getItemDescritionId();
                String con2 = category1 + "," + category2;
                String con3 = category1 + "," + category2 + "," + category3;

                List<Activity> activityList = activityRepository.findAllByUseType(2);
                List<Activity> actList = new ArrayList<>();
                for (Activity act2 : activityList) {
                    if (category1.equals(act2.getCategoryId())) {
                        act2.setOrder(3);
                        actList.add(act2);
                    }
                    if (con2.equals(act2.getCategoryId())) {
                        act2.setOrder(2);
                        actList.add(act2);
                    }
                    if (con3.equals(act2.getCategoryId())) {
                        act2.setOrder(1);
                        actList.add(act2);
                    }
                }
                Collections.sort(actList, Comparator.comparing(Activity::getOrder));
                if (actList.size() > 0 && actList != null)
                    activity = actList.get(0);
            }

        }

        //特定商品
        if (activityRepository.existsByUseType(3)) {
            List<Activity> list = activityRepository.findAllByUseType(3);
            for (Activity act3 : list) {
                String[] itemIdArr = act3.getItemIds().split(",");
                List<String> idList = Arrays.asList(itemIdArr);
                if (idList.contains(itemId))
                    activity = act3;
                break;
            }

        }

        return activity;
    }
}
