package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.base.StateConstant;
import com.example.afrishop_v3.config.DomainProperties;
import com.example.afrishop_v3.enums.ResultCodeEnum;
import com.example.afrishop_v3.enums.SexEnum;
import com.example.afrishop_v3.enums.UserTypeEnum;
import com.example.afrishop_v3.models.*;
import com.example.afrishop_v3.payload.request.LoginRequest;
import com.example.afrishop_v3.repository.NetworkRepository;
import com.example.afrishop_v3.repository.TbCfCouponRepository;
import com.example.afrishop_v3.repository.TbCfToicouponRepository;
import com.example.afrishop_v3.repository.UserRepository;
import com.example.afrishop_v3.security.jwt.JwtUtils;
import com.example.afrishop_v3.security.services.UserDetailsImpl;
import com.example.afrishop_v3.util.*;
import net.sf.json.JSONObject;
import org.apache.http.Consts;
import org.hashids.Hashids;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Optional;

@CrossOrigin(origins = "*", maxAge = 3600)
@RestController
@RequestMapping("/api/auth")
public class AuthController extends Controller {
    private final AuthenticationManager authenticationManager;

    private final UserRepository userRepository;
    private final EmailHelper emailHelper;
    private final TbCfCouponRepository couponRepository;
    private final TbCfToicouponRepository toicouponRepository;
    private final NetworkRepository networkRepository;
    //    @PersistenceContext(unitName = "afrishop_v3")
    private final EntityManager entityManager;
//    private final TbCfOrderRepository cfOrderRepository;
//    private final SecondOrderRepository secondOrderRepository;
//    private final SecondAddressRepository secondAddressRepository;
//    private final SecondUserRepository secondUserRepository;

    private final PasswordEncoder encoder;
    private final DomainProperties domainProperties;


    private final JwtUtils jwtUtils;
    private static Logger logger = LoggerFactory.getLogger(AuthController.class);

    public AuthController(DomainProperties domainProperties, PasswordEncoder encoder, JwtUtils jwtUtils, AuthenticationManager authenticationManager, UserRepository userRepository, EmailHelper emailHelper, TbCfCouponRepository couponRepository, TbCfToicouponRepository toicouponRepository, NetworkRepository networkRepository, EntityManager entityManager) {
        this.authenticationManager = authenticationManager;
        this.userRepository = userRepository;
        this.emailHelper = emailHelper;
        this.couponRepository = couponRepository;
        this.toicouponRepository = toicouponRepository;
        this.networkRepository = networkRepository;
        //this.secondAddressRepository = secondAddressRepository;
        this.entityManager = entityManager;
        this.encoder = encoder;
        this.domainProperties = domainProperties;
        this.jwtUtils = jwtUtils;
//        this.cfOrderRepository = cfOrderRepository;
//        this.secondOrderRepository = secondOrderRepository;
//        this.secondUserRepository = secondUserRepository;

    }

//    @GetMapping("count")
//    public Result count(){
//
//        List<TbCfOrder> cfOrders = cfOrderRepository.findAll(PageRequest.of(0, 5)).toList();
//        List<TbCfOrder2> cfOrders2 = secondOrderRepository.findAll(PageRequest.of(0, 5)).toList();
//
//        LinkedHashMap<String, Object> hashMap = new LinkedHashMap<>();
//
//        hashMap.put("orders",cfOrders);
//        hashMap.put("orders2",cfOrders2);
//
//        return new Result<>(hashMap);
//    }

//    private Result scanSecondDatabase(LoginRequest loginRequest) {
//        Result<Object> notFound = new Result<>(ResultCodeEnum.VALIDATE_ERROR.getCode(), "User not found");
//
//        Optional<TbCfUserInfo2> firstByAccount = secondUserRepository.findFirstByAccount(loginRequest.getAccount());
//        if( firstByAccount.isPresent() ){
//            TbCfUserInfo userInfo = new TbCfUserInfo();
//            TbCfUserInfo2 userInfo2 = firstByAccount.get();
//            String userId = userInfo.getUserId();
//            BeanUtilsBean notNull=new NullAwareBeanUtilsBean();
//            try {
//                notNull.copyProperties(userInfo,userInfo2);
//            } catch (InvocationTargetException | IllegalAccessException e) {
//                System.out.println(e.getMessage());
//            }
//
//            List<TbCfOrder2> allByUserId = secondOrderRepository.findAllByUserId(userId);
//
//            List<TbCfOrder> orderList = allByUserId.stream().map(v->{
//                TbCfOrder tbCfOrder = new TbCfOrder();
//                try {
//                    notNull.copyProperties(tbCfOrder,v);
//                } catch (IllegalAccessException | InvocationTargetException e) {
//                    System.out.println(e.getMessage());
//                }
//                return tbCfOrder;
//            }).collect(Collectors.toList());
//
//            List<TbCfAddress2> addresses = secondAddressRepository.findAllByUserId(userId);
//
//            List<TbCfAddress> collectAddresses = addresses.stream().map(v -> {
//                TbCfAddress address = new TbCfAddress();
//                try {
//                    notNull.copyProperties(address, v);
//                } catch (IllegalAccessException | InvocationTargetException e) {
//                    System.out.println(e.getMessage());
//                }
//                return address;
//            }).collect(Collectors.toList());
//
//            LinkedHashMap<String, Object> hashMap = new LinkedHashMap<>();
//
//            hashMap.put("addresses",collectAddresses);
//            hashMap.put("orders",orderList);
//            hashMap.put("user",userInfo);
//
//            return new Result<>(hashMap);
//
//        }
//
//        return notFound;
//    }

    @GetMapping("/getRealIp")
    public Result getRealIp(HttpServletRequest request) {
        String ip = this.getRealIpAddress(request);
        return new Result().setData(ip);
    }

    //Sign in using email/phone and password
    @PostMapping("/signin")
    public Result authenticateUser(@RequestBody LoginRequest loginRequest) {

        Optional<TbCfUserInfo> byAccount = userRepository.findFirstByAccount(loginRequest.getAccount());
        Result<Object> notFound = new Result<>(ResultCodeEnum.VALIDATE_ERROR.getCode(), "Incorrect phone number or password");


        if (!byAccount.isPresent()) {
//
//            boolean b = userRepository.existsByAccount(loginRequest.getAccount());
//
//            if (b) {
//                Optional<TbCfUserInfo> firstByAccount = userRepository.findFirstByAccount(loginRequest.getAccount());
//                if (firstByAccount.isPresent()) {
//                    TbCfUserInfo userInfo = firstByAccount.get();
//                    userInfo.setFirebaseUid(loginRequest.getAccount());
//                    fixCode(userInfo);
//                    try {
//                        userRepository.save(userInfo);
//                    } catch (Exception e) {
//                        return notFound;
//                    }
//                    byAccount = Optional.of(userInfo);
//                } else return notFound;
//            } else
            return notFound;
        }


        TbCfUserInfo userInfo = byAccount.get();

        fixCode(userInfo);

        Authentication authentication;
        try {

            authentication = authenticationManager.authenticate(
                    new UsernamePasswordAuthenticationToken(userInfo.getUserId(), loginRequest.getPassword()));
        } catch (BadCredentialsException e) {
            return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(), "Invalid username or password");
        }


        //Generate token
        SecurityContextHolder.getContext().setAuthentication(authentication);
        String jwt = jwtUtils.generateJwtToken(authentication);

        UserDetailsImpl userDetails = (UserDetailsImpl) authentication.getPrincipal();
//        List<String> roles = userDetails.getAuthorities().stream()
//                .map(GrantedAuthority::getAuthority)
//                .collect(Collectors.toList());


        userInfo.setToken(jwt);

        if (loginRequest.getFcm() != null) {
            userInfo.setFcm(loginRequest.getFcm());
        }


        userInfo.setLastLoginTime(new Date());
        userInfo.setUserType(UserTypeEnum.EMAIL.getCode());
        userRepository.save(userInfo);

        if (userInfo.hasFcm()) {
            sendNotification(userInfo.getFcm(), "Welcome ", userInfo.display() + ", Welcome and start shopping !!!");
        }

        return new Result<>(userInfo);
    }


    //Verify sent user code
    @GetMapping("/verifyCode/{account}/{code}")
    public Result<Boolean> validateCode(@PathVariable("account") String account,
                                        @PathVariable("code") String code) {
        Optional<TbCfUserInfo> userInfoOptional = userRepository.findFirstByAccount(account);
        if (!userInfoOptional.isPresent())
            return new Result<>(ResultCodeEnum.VALIDATE_ERROR.getCode(), "Account not found");

        TbCfUserInfo userInfo = userInfoOptional.get();

        //check validity
        if (code.equals(userInfo.getVerificationCode())) {
            return new Result<>(true, "Verification code is right !!!");
        }

        return new Result<>(false, ResultCodeEnum.VALIDATE_ERROR.getCode(), "Verification code is wrong !!!");
    }

    //Register new user with email
    @PostMapping("/signup")
    public Result<?> registerUser(@RequestBody TbCfUserInfo signUpRequest, HttpServletRequest request) {
        try {
//			boolean byAccount = userRepository.existsByAccount(signUpRequest.getEmail());
//			if ( byAccount ) {
//				return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(),"Error: Username is already taken!");
//			}
            String email = signUpRequest.getEmail();

            String password = signUpRequest.getPassword();

            email = email == null ? "" : email.trim();


            if (email.isEmpty()) {
                return new Result<>(ResultCodeEnum.VALIDATE_ERROR.getCode(), "Email is empty");
            }

            if (!isEmailValid(email)) {
                return new Result<>(ResultCodeEnum.VALIDATE_ERROR.getCode(), "Invalid email");
            }

            String validatePassword = validatePassword(password);

            if (validatePassword != null) {
                return new Result<>(ResultCodeEnum.VALIDATE_ERROR.getCode(), validatePassword);
            }

            boolean byEmail = userRepository.existsByFirebaseUid(email);
            boolean byEmail2 = userRepository.existsByAccount(email);

            //Check if email exists
            if (byEmail || byEmail2) {
                return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(), "This email address has been registered, please Login");
            }


            //signUpRequest.setFirebaseUid(email);

            signUpRequest.setUserId(IdUtil.createIdbyUUID());

            fillUserNecessayInfo(signUpRequest, request);
            signUpRequest.setAccount(email);

            signUpRequest.setPassword(encoder.encode(password));

            signUpRequest.setLastLoginTime(new Date());


            fixCode(signUpRequest);

            signUpRequest.setUserType(UserTypeEnum.EMAIL.getCode());

            TbCfUserInfo userInfo = userRepository.save(signUpRequest);


            //addToNetwork(signUpRequest);


            fixCoupon(signUpRequest);

            return authenticateUser(new LoginRequest(userInfo.getAccount(), password, userInfo.getFcm()));
        } catch (Exception e) {
            System.out.println(e.getMessage());
            return new Result<>(ResultCodeEnum.SERVICE_ERROR.getCode(), e.getMessage());
        }
    }


    private String validatePassword(String password) {

        if (password == null || password.isEmpty()) {
            return "Password is Empty";
        }


//            if (!isPasswordValidDigit(password)) {
//                string += ", a digit must occur at least once";
//            }
//
//            if (!isPasswordValidUpperCase(password)) {
//                string += ", an upper case letter must occur at least once";
//            }

        if (!isPasswordValidLength(password)) {
            String string = "Password is not strong, at least eight characters though";


            return string;
        }

        return null;
    }

    @PostMapping("/signup/phone")
    public Result<?> registerUserPhone(@RequestBody TbCfUserInfo signUpRequest, HttpServletRequest request) {
        try {
//			boolean byAccount = userRepository.existsByAccount(signUpRequest.getEmail());
//			if ( byAccount ) {
//				return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(),"Error: Username is already taken!");
//			}

            String phone = signUpRequest.getPhone();

            String password = signUpRequest.getPassword();

            phone = phone == null ? "" : phone.trim();


            if (phone.isEmpty()) {
                return new Result<>(ResultCodeEnum.VALIDATE_ERROR.getCode(), "Phone is empty");
            }

            if (!isPhoneValid(phone)) {
                return new Result<>(ResultCodeEnum.VALIDATE_ERROR.getCode(), "Invalid phone");
            }

            String validatePassword = validatePassword(password);

            if (validatePassword != null) {
                return new Result<>(ResultCodeEnum.VALIDATE_ERROR.getCode(), validatePassword);
            }


            boolean byEmail = userRepository.existsByFirebaseUid(phone);
            boolean byEmail2 = userRepository.existsByAccount(phone);

            if (byEmail || byEmail2) {
                return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(), "This phone number has been registered, please Login");
            }


            //signUpRequest.setFirebaseUid(phone);

            signUpRequest.setUserId(IdUtil.createIdbyUUID());

            fillUserNecessayInfo(signUpRequest, request);
            signUpRequest.setAccount(phone);

            signUpRequest.setPassword(encoder.encode(password));

            signUpRequest.setLastLoginTime(new Date());


            fixCode(signUpRequest);

            signUpRequest.setUserType(UserTypeEnum.PHONE.getCode());

            TbCfUserInfo userInfo = userRepository.save(signUpRequest);


            //addToNetwork(signUpRequest);


            fixCoupon(signUpRequest);

            return authenticateUser(new LoginRequest(userInfo.getAccount(), password, userInfo.getFcm()));
        } catch (Exception e) {
            System.out.println(e.getMessage());
            return new Result<>(ResultCodeEnum.SERVICE_ERROR.getCode(), e.getMessage());
        }
    }


    @PostMapping(value = "/register/user")
    public Result checkFirebase(@RequestBody TbCfUserInfo user, HttpServletRequest request) throws IOException {
        //Data to be userInfoVo
//        {
//            "firebaseUid":"firebaseUid",
//            "name":"name",
//            "email":"email",
//            "phone":"phone",
//            "birthDate":"date",
//            "token":"token",
//        }

        // Check if firebase token is valid
        logger.info("从firebase中获取的user:" + user);

        if (user.getPhone() != null) {
            user.setAccount(user.getPhone());
        }
        boolean isTokenValid = user.getToken() != null && validateFirebaseToken(user.getToken());


        String firebaseUid = user.getFirebaseUid();

        // if valid do sign in if firebase Uid exist in database or register as new user
        if (isTokenValid) {
            //Query to find user from database by firebase uid
            Optional<TbCfUserInfo> optional = userRepository.findByFirebaseUid(firebaseUid);

            if (!optional.isPresent() && user.getEmail() != null && !user.getEmail().isEmpty() && userRepository.existsByAccount(user.getEmail())) {
                optional = userRepository.findFirstByAccount(user.getEmail());
            }

            if (!optional.isPresent() && user.getPhone() != null && !user.getPhone().isEmpty() && userRepository.existsByAccount(user.getPhone().replace("+", ""))) {
                optional = userRepository.findFirstByAccount(user.getPhone().replace("+", ""));
            }
            logger.info("user is exist:" + optional.isPresent());
            if (!optional.isPresent()) {


                String userid = IdUtil.createIdbyUUID();

                // user.setPassword(encoder.encode(firebaseUid));
                user.setUserId(userid);

                fillUserNecessayInfo(user, request);
                user = userRepository.save(user);


                //赠送用户优惠券
                fixCoupon(user);
            } else {
                TbCfUserInfo userInfo = optional.get();

                if (user.hasFcm()) {
                    userInfo.setFcm(user.getFcm());
                }

                if (userInfo.getFirebaseUid() == null) {
                    userInfo.setFirebaseUid(firebaseUid);
                }

                String property = domainProperties.getProperty("user.avatar");

                property = property == null ? "" : property;

                boolean b = property.equals(userInfo.getAvatar()) || userInfo.getAvatar() == null || userInfo.getAvatar().isEmpty();


                if (user.getAvatar() != null && b) {
                    userInfo.setAvatar(user.getAvatar());
                }

                boolean b1 = userInfo.getNick() == null || userInfo.getNick().isEmpty();
                if (user.getNick() != null && b1) {
                    userInfo.setNick(user.getNick());
                }

                if (user.getEmail() != null) {
                    userInfo.setEmail(user.getEmail());
                }

                if (user.getUserType() != null) {
                    userInfo.setUserType(user.getUserType());
                }

                if (user.getPhone() != null) {
                    userInfo.setPhone(user.getPhone());
                }

                user = userInfo;

            }


            fixCode(user);

            //addToNetwork(user);

            user.setLastLoginTime(new Date());

            if (user.getAccount() == null) {
                user.setAccount(user.getEmail() != null ? user.getEmail() : user.getPhone());
            }

            if (user.getNick() == null) {
                user.setNick(user.getEmail() != null ? user.getEmail() : user.getPhone());
            }

            userRepository.save(user);
            //注册成功 创建token


            Authentication authentication;
            try {
                authentication = new UsernamePasswordAuthenticationToken(UserDetailsImpl.build(user), null);
            } catch (BadCredentialsException e) {
                return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(), "Invalid username or password");
            }

            SecurityContextHolder.getContext().setAuthentication(authentication);
            String jwt = jwtUtils.generateJwtToken(authentication);

            user.setToken(jwt);

            return new Result<>(user);


        } else {
            return new Result<>(ResultCodeEnum.ILLEGAL_ARGUMENT.getCode(), ResultCodeEnum.ILLEGAL_ARGUMENT.getDesc());
        }


    }


    private void fixCoupon(TbCfUserInfo user) {
        logger.info("Issue coupons to new users...");
        try {
            List<TbCfCoupon> couponVailList = couponRepository.findAllByCouponVaild(1);
            //获取当前时间的时分秒
            // SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");//设置日期格式
            Calendar c = Calendar.getInstance();
            Date startDate = new Date();
            c.setTime(startDate);
            c.add(Calendar.DATE, 7);
            Date endDate = c.getTime();
            for (TbCfCoupon tbCfCoupon : couponVailList) {
                logger.info("coupon:" + tbCfCoupon.getCouponTitle());
                TbCfToicoupon toi = new TbCfToicoupon();
                //把上面获取到的值，赋值到实体类中
                toi.setToitableId(IdUtil.createIdbyUUID());
                toi.setCoupon(tbCfCoupon);
                toi.setUserId(user.getUserId());
                toi.setStartTime(startDate);
                toi.setIdentification(3);
                toi.setEnableFlag(1);
                toi.setEndTime(endDate);
                toicouponRepository.save(toi);
            }
        } catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    // Copy code from old user_info table or generate new one
    private void fixCode(TbCfUserInfo user) {

        if (user.getCode() == null) {
            try {
                Query nativeQuery = entityManager.createNativeQuery("select b.code as data FROM user_info b where b.external_id=:user limit 1");

                nativeQuery.setParameter("user", user.getUserId());

                if (nativeQuery.getSingleResult() != null) {
                    user.setCode(nativeQuery.getSingleResult().toString());
                }
            } catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }

        if (user.getCode() == null) {
            Hashids hashids = new Hashids("big_afr_dev", 6);
            Long codeCount = user.getCodeCount();

            Calendar cal = Calendar.getInstance();
            long currentTime = cal.getTimeInMillis();
            long Max = 9999999999999L;
            long Min = 1000000000000L;
            long range = Math.abs((long) (Math.random() * (Max - Min)) + Min);
            long id = Math.addExact(currentTime, range);

            if (codeCount == null) {
                id = userRepository.count() + id;
            }

            user.setCode(hashids.encode(id));
        }
    }

    //Auto newtork register
    private void addToNetwork(TbCfUserInfo user) {
        Network top = networkRepository.findTopByOrderByIdDesc();

        if (top != null && !user.invited()) {
            if (!networkRepository.existsByUserInfo_UserIdAndNetworkInfo_UserId(top.getNetworkId(), user.getUserId())) {
                Network network = new Network();
                network.setUserInfo(top.getNetworkInfo());
                network.setNetworkInfo(user);
                //network.setId(uid());
                networkRepository.save(network);
                user.setInvitation(1);
            }
        }
    }

    //fill basic information for new user
    private void fillUserNecessayInfo(TbCfUserInfo tbCfUserInfoVo, HttpServletRequest request) throws IOException {
//        RestTemplate restTemplate = new RestTemplate();
        if (tbCfUserInfoVo.getAvatar() == null) tbCfUserInfoVo.setAvatar(domainProperties.getProperty("user.avatar"));
//        ResponseEntity forEntity2 = restTemplate.getForEntity("http://admin.afrieshop.com/api/upload/getRealIp", String.class);
//        System.err.println(forEntity2.getBody());
//        String body = (String) forEntity2.getBody();
//        String ip = JSONObject.fromObject(body).getString("ip");
//        System.out.println(ip);
        String ip = getIpAddr(request);
        String country = HttpsUtil.useIpFindCountry(ip);
//        String country = HttpsUtil.ipToAdress(ip);

        tbCfUserInfoVo.setCountry(country);
        tbCfUserInfoVo.setUserNo(IdUtil.createIdByDate());
        tbCfUserInfoVo.setPhoneFlag(StateConstant.INVALID);
        tbCfUserInfoVo.setLoginCount(0);
        tbCfUserInfoVo.setCreateTime(new Date());
        tbCfUserInfoVo.setSex(SexEnum.UNKNOW.getCode());
        tbCfUserInfoVo.setInvitedCount(0);
        tbCfUserInfoVo.setEnableFlag(StateConstant.VALID);
        //目前有验证码的都是邮箱类型
        if (tbCfUserInfoVo.getUserType() == null)
            tbCfUserInfoVo.setUserType(UserTypeEnum.UN_KNOW.getCode());
        tbCfUserInfoVo.setEmailFlag(StateConstant.INVALID);

        if (tbCfUserInfoVo.getNick() == null) {
            tbCfUserInfoVo.setNick(tbCfUserInfoVo.getEmail() != null ? tbCfUserInfoVo.getEmail() : tbCfUserInfoVo.getPhone() != null ? tbCfUserInfoVo.getPhone() : tbCfUserInfoVo.getAccount());
        }
        if (tbCfUserInfoVo.getAccount() == null) {
            tbCfUserInfoVo.setAccount(tbCfUserInfoVo.getEmail() != null ? tbCfUserInfoVo.getEmail() : tbCfUserInfoVo.getPhone() != null ? tbCfUserInfoVo.getPhone() : tbCfUserInfoVo.getUserNo());
        }
        logger.info("user===" + tbCfUserInfoVo);

    }

    @PostMapping("/resetPassword/{account}")
    public Result resetPassword(@PathVariable("account") String account, @RequestBody PasswordModel model) {

        Optional<TbCfUserInfo> firstByAccount = userRepository.findFirstByAccount(account);

        if (!firstByAccount.isPresent())
            return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(), "User not found !!!");

        if (model == null) return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(), "Empty body");

        String code = model.getCode();

        if (code == null || code.isEmpty())
            return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(), "Verification Code is required !!");

        String password = model.getPassword();

        if (password == null || password.isEmpty())
            return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(), "New password is required !!");

        String validatePassword = validatePassword(password);

        if (validatePassword != null) {
            return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(), validatePassword);
        }

        TbCfUserInfo user = firstByAccount.get();

        if (user.getVerificationCode() != null && user.getVerificationCode().equals(code)) {
            user.setPassword(encoder.encode(password));
            userRepository.save(user);
            return new Result("Password reset successfully !");
        } else {
            return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(), "Verification code don't match !");
        }

    }

    @GetMapping("/checkAccountAvailability/{account}")
    public Result checkUsername(@PathVariable("account") String account) {
        boolean exists = userRepository.existsByAccount(account);

        if (exists) {
            return new Result<>(
                    true,
                    ResultCodeEnum.SUCCESS.getCode(),
                    "Account exists"
            );
        }

        return new Result<>(
                false,
                ResultCodeEnum.VALIDATE_ERROR.getCode(),
                "Account does not exist"
        );
    }


    @GetMapping("/forgotPassword/{account}")
    public Result getUserPhoneCode(@PathVariable("account") String account) {

        Optional<TbCfUserInfo> byAccount = userRepository.findFirstByAccount(account);

        if (!byAccount.isPresent())
            return new Result<>(ResultCodeEnum.VALIDATE_ERROR.getCode(), "Account not found !!!");

        TbCfUserInfo user = byAccount.get();

        if (isPhoneValid(account)) return sendPhoneCode(user, account);

        if (isEmailValid(account)) return getEmailCode(user, account);


        return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(), "Invalid phone number or email");
    }

    private Result getEmailCode(TbCfUserInfo user, String email) {

        try {
            EmailTemplateBo emailTemplateBo = new EmailTemplateBo();
            String name = URLDecoder.decode(email, Consts.UTF_8.name());
            Integer randomCode = RandomCodeHelper.producedRandomCode(6);
            emailTemplateBo.setNick(name);
            emailTemplateBo.setIdentifyCode(randomCode);
            Integer identifyCode = emailHelper.sendIdentifyEmail(email, EmailTemplateConstant.REGISTER, emailTemplateBo);
            user.setVerificationCode(String.valueOf(identifyCode));
            userRepository.save(user);
            return new Result("Verification code has been sent");
        } catch (Exception e) {
            return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(), e.getMessage());
        }
    }

    private Result sendPhoneCode(TbCfUserInfo user, String phone) {
        Result result = new Result();
        try {
            phone = "+" + phone.trim();
            Integer sentCount = user.getSentCount();

            if (sentCount == null) {
                user.setSentCount(-1);
                sentCount = 1;
            }

            Date date = new Date();

            Date sentTime = user.getCodeSentTime();


            long diff = date.getTime() - (sentTime == null ? 0 : sentTime.getTime());

            long diffMinutes = diff / (60 * 1000) % 60;

            if (diffMinutes > 15 && sentCount >= 3) {
                sentCount = -1;
                user.setSentCount(sentCount);
            }

            boolean canSend = sentCount < 3;


            if (canSend) {
                result.setMessage("Verification code has been sent");
                //发送验证码
                String code = SMSUtil.yzCode(phone);
                user.setCodeSentTime(date);
                user.setVerificationCode(code);
                user.setSentCount(user.getSentCount() + 1);
                userRepository.save(user);
                logger.info("用户[" + phone + "]获取验证码成功，" + "验证码：" + code);
            } else {
                //用户频繁操作
                result.setCode(ResultCodeEnum.SERVICE_ERROR.getCode());
                result.setMessage("Frequent operation, please try again after 15 minutes");
                logger.info("用户[" + phone + "]获取验证码失败，操作频繁，15分钟后重试");
            }
        } catch (Exception e) {
            result.setCode(ResultCodeEnum.SERVICE_ERROR.getCode());
            result.setMessage(e.toString());
            logger.info("用户[" + phone + "]获取验证码发生异常--->>>" + e.toString());
        }
        return result;
    }
}
