package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.models.Reply;
import com.example.afrishop_v3.repository.ReplyRepository;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/discover/replies")
public class ReplyController {
    private final ReplyRepository repository;

    public ReplyController(ReplyRepository repository) {
        this.repository = repository;
    }

    @GetMapping(value = "/RepliesByCommentId/{commentId}")
    //@PreAuthorize("hasAuthority('ADMIN_USER') or hasAuthority('STANDARD_USER')")
    public List<Reply> getList(@PathVariable(value = "commentId") String id, @RequestParam(value = "pageNo") Integer pageNo, @RequestParam(value = "pageSize") Integer pageSize) {
        return repository.findAllByCommentId(id, PageRequest.of(pageNo, pageSize)).toList();
    }


    @PostMapping(value ="/saveReply")
    public Reply saveReply(@ModelAttribute("Reply") Reply reply){
        return repository.save(reply);
    }
}
