package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.base.StateConstant;
import com.example.afrishop_v3.models.TbCfFeedback;
import com.example.afrishop_v3.repository.TbCfFeedbackRepository;
import org.springframework.web.bind.annotation.*;

import java.util.Date;

@RestController
@RequestMapping("/feedback")
public class FeedbackController extends Controller{
    private final TbCfFeedbackRepository repository;

    public FeedbackController(TbCfFeedbackRepository repository) {
        this.repository = repository;
    }


    @PostMapping
    public Result saveFeedbackList(@RequestBody TbCfFeedback feedback) {
        feedback.setFeedbackId(uid());
        feedback.setCreateTime(new Date());
        feedback.setEnableFlag(StateConstant.VALID);
        return new Result<>(repository.save(feedback));
    }

    @GetMapping
    public Result getFeedbackList() {
        return new Result<>(repository.findAll());
    }
}
