package com.example.afrishop_v3.controllers;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.base.StateConstant;
import com.example.afrishop_v3.enums.ResultCodeEnum;
import com.example.afrishop_v3.models.*;
import com.example.afrishop_v3.repository.TbCfCartRecordRRepository;
import com.example.afrishop_v3.repository.TbCfExpressTemplateRepository;
import com.example.afrishop_v3.repository.TbCfItemSkuRepository;
import com.example.afrishop_v3.repository.TbCfStationItemRepository;
import com.example.afrishop_v3.security.services.AuthenticationUser;
import com.example.afrishop_v3.service.SpiderService;
import com.example.afrishop_v3.util.ValidateUtils;
import com.example.afrishop_v3.util.WordposHelper;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;

@RestController
@RequestMapping("/cart")
public class CartController extends Controller {
    private final TbCfCartRecordRRepository repository;
    private final TbCfStationItemRepository itemRepository;
    private final TbCfExpressTemplateRepository templateRepository;
    private final TbCfItemSkuRepository skuRepository;
    private final TbCfItemSkuRepository itemSkuRepository;
    private final AuthenticationUser user;
    private final SpiderService spiderService;
    private final ReentrantLock lock = new ReentrantLock();
    private static Logger logger = LoggerFactory.getLogger(CartController.class);


    public CartController(TbCfCartRecordRRepository repository, TbCfStationItemRepository itemRepository, TbCfExpressTemplateRepository templateRepository, TbCfItemSkuRepository skuRepository, TbCfItemSkuRepository itemSkuRepository, AuthenticationUser user, SpiderService spiderService) {
        this.repository = repository;
        this.itemRepository = itemRepository;
        this.templateRepository = templateRepository;
        this.skuRepository = skuRepository;
        this.itemSkuRepository = itemSkuRepository;
        this.user = user;
        this.spiderService = spiderService;
    }

    //Change number of the cart item
    @PutMapping("/num/{cartId}/{itemNum}")
    public Result changeItemNum(@PathVariable String cartId, @PathVariable int itemNum) {
        Result result = new Result();
        try {
            Optional<TbCfCartRecordR> byId = repository.findById(cartId);

            if (byId.isPresent()) {
                TbCfCartRecordR record = byId.get();
                //校验库存
                String itemSkuId = record.getItemSkuId();
                //把锁去了，因为购物车加减数量太慢，这里把暂时不考虑并发情况，在下单时校验库存即可
                //当然加锁也可以，多个用户同一时刻抢最后几个sku时可以及时提醒用户库存不足
                //个人感觉这样可以不加锁，1.暂时用户体量很难出现多个用户同时抢购的情况
                // 2.加锁影响用户体验 3.加购可以不用强一致性（当然下单必须保证库存不超卖）
                //后面的兄弟可以根据业务进行权衡 ~~~哈哈哈~~~
//                lock.lock();
                Optional<TbCfItemSkus> byId1 = skuRepository.findById(itemSkuId);
                Integer count = itemNum;
                if (byId1.isPresent()) {
                    Integer itemCount = byId1.get().getSkuCount();

                    if (itemCount < itemNum) {
                        if (itemCount <= 0) {
                            record.setCheckFlag(0);
                            itemCount = 0;

                        }
                        if (itemCount != 0)
                            count = itemCount;
                        result.setData(itemCount);
                        result.setMessage("Only " + itemCount + " item(s) in stocks");
                        result.setCode(ResultCodeEnum.SERVICE_ERROR.getCode());
                    }
                }
//                lock.unlock();
                record.setItemNum(count);
                repository.save(record);
                return result;
            }


            logger.warn("Cart record not found !");

            return new Result<>(ResultCodeEnum.SERVICE_ERROR.getCode(), "Failed");
        } finally {
//            lock.unlock();
        }
    }

/*    public synchronized boolean checkStock(String itemSkuId, int itemNum) {
        Optional<TbCfItemSkus> skuOpt = skuRepository.findById(itemSkuId);
        if (skuOpt.isPresent()) {
            Integer skuCount = skuOpt.get().getSkuCount();
            if (itemNum <= skuCount) {
                return true;
            }
        }
        return false;
    }*/

    //Add single item to the cart
    @PostMapping
    public Result addToCart(@RequestBody TbCfCartRecordR itemDetail) {
        boolean check = checkItemStatus(itemDetail.getItemId());
        if (!check) {
            return new Result(ResultCodeEnum.SERVICE_ERROR.getCode(), "the goods are sold out");
        }
        TbCfUserInfo user = this.user.user();

        if (user == null) {
            return new Result(ResultCodeEnum.UN_LOGIN.getCode(), "need login");
        }
        String userId = user.getUserId();

        if (itemDetail == null) {
            return new Result(ResultCodeEnum.SERVICE_ERROR.getCode(), "Request body is empty");
        }

        // Not necessary because it will always be overwritten by sku price
//        if (itemDetail.getItemPrice() != null || itemDetail.getSkuPrice() != null || itemDetail.getRealItemPrice() != null) {
//            return new Result(ResultCodeEnum.SERVICE_ERROR.getCode(), "Invalid request, Parameter cannot contain price field");
//        }
        int count = repository.countByUserIdAndEnableFlag(userId, 1);

        if (count > 99) {
            return new Result(ResultCodeEnum.SERVICE_ERROR.getCode(), "Your shopping cart is full");
        }

        String itemSkuId = itemDetail.getItemSkuId();

        String targetUrl = itemDetail.getTargetUrl();

        Result skuNotFound = new Result(ResultCodeEnum.SERVICE_ERROR.getCode(), "Item sku not found");
        if (itemSkuId == null && targetUrl == null)
            return skuNotFound;

        BigDecimal price = null;

        if (itemSkuId != null) {


            Optional<TbCfItemSkus> skuOptional = itemSkuRepository.findById(itemSkuId);

            if (!skuOptional.isPresent()) {
                return skuNotFound;
            }
            price = skuOptional.get().getSkuPrice();
        }

        //Go for reptile products
        if (targetUrl != null && itemSkuId == null) {
            try {
                JSONObject detail = spiderService.getItemDetail(targetUrl);

                if (!detail.containsKey("originalPriceList")) {
                    logger.warn("No price detected from reptile products");
                    return skuNotFound;
                }

                JSONArray priceList = detail.getJSONArray("originalPriceList");
                if (priceList.isEmpty()) {
                    logger.warn("No price detected from reptile products");
                    return skuNotFound;
                } else
                    price = BigDecimal.valueOf(priceList.getJSONObject(0).getDouble("price"));
            } catch (InterruptedException | IOException | ExecutionException | URISyntaxException | TimeoutException e) {
                logger.debug(e.getMessage());
                return skuNotFound;
            }
        }

        if (price == null || price.compareTo(BigDecimal.ZERO) <= 0) {
            String s = "The price of the goods is incorrect";
            logger.debug(s);
            return new Result(ResultCodeEnum.SERVICE_ERROR.getCode(), s);
        }

        itemDetail.setItemPrice(price);

        Optional<TbCfCartRecordR> optionalItem;
        String itemId = itemDetail.getItemId();
        boolean hasItemId = itemId != null && !itemId.isEmpty();
        if (hasItemId) {
            optionalItem = repository.findFirstByUserIdAndItemImgAndItemSkuAndEnableFlag(userId, itemDetail.getItemImg(), itemDetail.getItemSku(), 1);
        } else {
            optionalItem = repository.findFirstByUserIdAndSourceItemIdAndItemSkuAndEnableFlag(userId, itemDetail.getSourceItemId(), itemDetail.getItemSku(), 1);
        }

        TbCfCartRecordR detail;


        if (optionalItem.isPresent()) {

            detail = optionalItem.get();

            itemId = detail.getItemId();

        } else {
            itemId = itemId != null && !itemId.isEmpty() ? itemId : uid();
            updateItemCategory(itemDetail);
        }

        // Check if the item exist in cart
        Optional<TbCfCartRecordR> cartOptional = repository.findFirstByUserIdAndItemIdAndItemSkuAndEnableFlag(userId, itemId, itemDetail.getItemSku(), 1);
        Integer flag = itemDetail.getCheckFlag() != null ? itemDetail.getCheckFlag() : StateConstant.VALID;

        if (cartOptional.isPresent()) {
            TbCfCartRecordR cart = cartOptional.get();
            cart.setCheckFlag(flag);
            cart.increaseNum(itemDetail.getItemNum());
            repository.save(cart);
        } else {
            //detail.setItemNum(itemDetail.getItemNum());
            Integer index = itemDetail.getIndex();
            insertRecord(itemDetail, userId, flag, index);
        }

        if (user.hasFcm()) {
            int i = repository.countByUserIdAndEnableFlag(userId, 1);
            sendNotification(user.getFcm(), "Cart updates", "Item added to cart, " + i + " item(s) are pending, continue with order");
        }


        return new Result();
    }

    public boolean checkItemStatus(String itemId) {
        Optional<TbCfStationItem> byId = itemRepository.findById(itemId);
        if (byId.isPresent()) {
            TbCfStationItem item = byId.get();
            String status = String.valueOf(item.getEnableFlag());
            if ("1".equals(status)) {
                return true;
            }
        }
        return false;
    }

    @PostMapping("/addCartList")
    public Result addCartList(@RequestBody List<TbCfCartRecordR> cartList) {
        cartList.forEach(cart -> {
            logger.info(cart.getItemId() + "的index:" + cart.getIndex());
            addToCart(cart);
        });
        return new Result();
    }

    @PutMapping("/changeCartStatus/{status}")
    public Result changeCartStatus(@RequestBody String[] cartIds,
                                   @PathVariable("status") Integer status) {
        if (cartIds == null || status == null) {
            return new Result(ResultCodeEnum.SERVICE_ERROR.getCode(),
                    "The parameter cannot be null");
        }
        List<TbCfCartRecordR> cartList = repository.findAllByCartRecordIdIn(cartIds);
        cartList.forEach(cart -> {
            cart.setCheckFlag(status);
            repository.save(cart);
        });

        return new Result();
    }

    @GetMapping
    public Result getItemCartList(@RequestParam(value = "pageNo", defaultValue = "0") Integer pageNo,
                                  @RequestParam(value = "pageSize", defaultValue = "6") Integer pageSize) {
        List<TbCfCartRecordR> list = repository.findAllByUserIdOrderByCreateTimeDesc(user.userId(), PageRequest.of(pageNo, pageSize));

        list.stream().forEach(cart -> {
            if (cart.isOutOfStock()) {
                cart.setCheckFlag(0);
                repository.save(cart);
            }
        });

        return new Result<>(list);
    }

    //Delete by array of cart ids
    @DeleteMapping("/delete")
    public Result deleteItems(@RequestBody String[] ids) {
        if (ids != null) {
            repository.updateCartCheckFlag(ids);
            return new Result();
        }
        return new Result(ResultCodeEnum.SERVICE_ERROR.getCode(),
                ResultCodeEnum.SERVICE_ERROR.getDesc());
    }

    //Insert
    private void insertRecord(TbCfCartRecordR itemDetail, String userId, Integer checkFlag, Integer index) {
        //日期处理：因为批量加入购物车时日期都是相同的，所以需要加入索引，确保每个时间不相同，才能按时间降序排列(未登录)
        String now = DateUtil.now();
        if (index == null) index = 0;
        DateTime dateTime = DateUtil.offsetSecond(DateUtil.parse(now), index);
        itemDetail.setCartRecordId(uid());
        itemDetail.setCheckFlag(checkFlag);
        itemDetail.setEnableFlag(StateConstant.VALID);
        itemDetail.setUserId(userId);
        itemDetail.setCreateTime(dateTime);
        repository.save(itemDetail);
    }


    private TbCfCartRecordR updateItemCategory(TbCfCartRecordR tbCfItemDetail) {

        Optional<TbCfStationItem> byId = itemRepository.findById(tbCfItemDetail.getItemId());
        if (byId.isPresent() && byId.get().getExpress() != null) {
            tbCfItemDetail.setTemplate(byId.get().getExpress());
        } else {

//            if( byId.isPresent() ){
//                TbCfExpressTemplate templateIdAsc = templateRepository.findFirstByOrderByTemplateIdAsc();
//
//                if (templateIdAsc != null)
//                    tbCfItemDetail.setTemplate(templateIdAsc);
//            } else {
//            System.out.println("No template, keep processing");
//                TbCfExpressTemplate expressTemplate = null;
//                try {
//                    expressTemplate = recognizeItemCategory(tbCfItemDetail.getItemTitle());
//                } catch (Exception e) {
//                    System.out.println(e.getMessage());
//                }
//                if (expressTemplate != null) {
//                    tbCfItemDetail.setItemCategory(expressTemplate.getTemplateId());
//                    tbCfItemDetail.setTemplate(expressTemplate);
//                }else{
//
//                    // For crawling products
//                    Optional<TbCfExpressTemplate> templateOptional = templateRepository.findFirstByIsDefault(1);
//
//                    if ( templateOptional.isPresent() ){
//                        TbCfExpressTemplate template = templateOptional.get();
//                        tbCfItemDetail.setItemCategory(template.getTemplateId());
//                        tbCfItemDetail.setTemplate(template);
//                    }
//                }
            //}
        }


        return tbCfItemDetail;
        //logger.info("插入一条商品数据！");
    }

    private TbCfExpressTemplate recognizeItemCategory(String itemTitle) throws ExecutionException, InterruptedException, TimeoutException {
        Map<String, Object> wordResult = separateText(itemTitle);
        //pos_code 16为名词，用名词去匹配; 23非汉字串
        JSONArray baseTokens = (JSONArray) wordResult.get("base_tokens");
        List<String> keywordList = new ArrayList<>();
        for (Object baseToken : baseTokens) {
            JSONObject jsonObject = (JSONObject) baseToken;
            if (16 == (Integer) jsonObject.get("pos_code")) {
                keywordList.add((String) jsonObject.get("word"));
            }
            if (23 == (Integer) jsonObject.get("pos_code")) {
                keywordList.add((String) jsonObject.get("word"));
            }
        }
        //总的可能适用的运费模板
        Set<TbCfExpressTemplate> totalTemplateSet = new HashSet<>();
        if (!keywordList.isEmpty()) {
            for (String keyword : keywordList) {
                //根据keyword获取运费模板
                List<TbCfExpressTemplate> tbCfExpressTemplateList = templateRepository.getTemplateByKeyword(keyword);
                totalTemplateSet.addAll(tbCfExpressTemplateList);
                //TODO 后续优化
                if (ValidateUtils.isContainChinese(keyword)) {
                    if (0 == tbCfExpressTemplateList.size()) {
                        String[] split = keyword.split("");
                        for (int i = 0; i < split.length; i++) {
                            if (i + 1 <= split.length) {
                                List<TbCfExpressTemplate> tbCfExpressTemplateLists = templateRepository.getTemplateByKeyword(split[i] + split[i + 1]);
                                totalTemplateSet.addAll(tbCfExpressTemplateLists);
                            }
                        }
                    }
                }
            }
        }
        //没有的话就设置 其他
        if (totalTemplateSet.isEmpty()) {
            //根据keyword获取运费模板
            List<TbCfExpressTemplate> tbCfExpressTemplateList = templateRepository.getTemplateByKeyword("其他");
            totalTemplateSet.addAll(tbCfExpressTemplateList);
        }
        //取第一个运费
        Iterator<TbCfExpressTemplate> iterator = totalTemplateSet.iterator();
        return iterator.next();
    }


    private Map<String, Object> separateText(String text) throws ExecutionException, InterruptedException, TimeoutException {
        List<Map<String, Object>> futureList = new ArrayList<>();
        Map<String, Object> titleMap = new HashMap<>();
        titleMap.put("text", text);
        WordposHelper.separeteText(futureList, titleMap, text);
        WordposHelper.waitForResult(futureList);
        return titleMap;
    }

}
