package com.example.afrishop_v3.security.services;

import com.example.afrishop_v3.models.TbCfUserInfo;
import com.example.afrishop_v3.repository.UserRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

import java.util.Optional;

@Component
public class AuthenticationUser implements IAuthenticationFacade {
    private final UserRepository repository;
    private static Logger logger = LoggerFactory.getLogger(AuthenticationUser.class);

    public AuthenticationUser(UserRepository repository) {
        this.repository = repository;
    }

    @Override
    public Authentication getAuthentication() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    public TbCfUserInfo user() {
        String name = getAuthentication().getName();

//        UserDetailsImpl principal = (UserDetailsImpl) getAuthentication().getPrincipal();
//
//        System.out.println("principal");
//        System.out.println(principal);
//
////        logger.info("登录的用户：" + name);
//        System.out.println("name");
//        System.out.println(name);
        Optional<TbCfUserInfo> user = repository.findById(name);
//        logger.info("用户：" + user);
        return user.orElse(null);
    }

    public String userId() {
        TbCfUserInfo user = user();
        if (user != null) {
            return user().getUserId();
        }
        return null;
    }
}
