package com.example.afrishop_v3.models;

import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Entity;
import javax.persistence.Id;
import java.util.Date;

@Entity
@Getter
@Setter
@Where(clause = "enable_flag=1")
public class TbCfProblem {
    /**
     * 问题id
     */
    @Id
    private String problemId;
    /**
     * 问题明细
     */
    private String question;
    /**
     * 答案
     */
    private String answer;
    /**
     * 是否展示
     */
    private Integer enableFlag;
    /**
     * 排序
     */
    private Integer sort;
    /**
     * 创建时间
     */
    private Date createTime;

    private Integer type;

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    /**
     * 设置：问题id
     */
    public void setProblemId(String problemId) {
        this.problemId = problemId;
    }

    /**
     * 获取：问题id
     */
    public String getProblemId() {
        return problemId;
    }

    /**
     * 设置：问题明细
     */
    public void setQuestion(String question) {
        this.question = question;
    }

    /**
     * 获取：问题明细
     */
    public String getQuestion() {
        return question;
    }

    /**
     * 设置：答案
     */
    public void setAnswer(String answer) {
        this.answer = answer;
    }

    /**
     * 获取：答案
     */
    public String getAnswer() {
        return answer;
    }

    /**
     * 设置：是否展示
     */
    public void setEnableFlag(Integer enableFlag) {
        this.enableFlag = enableFlag;
    }

    /**
     * 获取：是否展示
     */
    public Integer getEnableFlag() {
        return enableFlag;
    }

    /**
     * 设置：创建时间
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取：创建时间
     */
    public Date getCreateTime() {
        return createTime;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }
}
