package com.example.afrishop_v3.models;

import lombok.Getter;
import lombok.Setter;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 启动页实体
 * 表名 tb_cf_home_page
 *
 * @author lipengjun
 * @date 2020-03-31 15:36:05
 */
@Getter
@Setter
@Entity
public class TbCfHomePage {

    /**
     * 启动页id
     */
    @Id
    private String pageId;
    /**
     * 图片名称
     */
    private String imgName;
    /**
     * 类型 0：不跳转，1：外链，2.分类子页面，3.商品列表页，4.商品
     */
    private Integer imgType;
    /**
     * 商品版本 0：旧版，1：新版
     */
    private Integer imgVersion;
    /**
     * 排序
     */
    private Integer sort;
    /**
     * 跳转链接
     */
    private String linkUrl;
    /**
     * 图片链接
     */
    private String imgUrl;
    /**
     * 是否支持浏览
     */
    private Integer scanFlag;
    /**
     * 是否跳转
     */
    private Integer redirectFlag;
    /**
     * 是否可用
     */
    private Integer enableFlag;

    /**
     * 设置：启动页id
     */
    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    /**
     * 获取：启动页id
     */
    public String getPageId() {
        return pageId;
    }
    /**
     * 设置：图片名称
     */
    public void setImgName(String imgName) {
        this.imgName = imgName;
    }

    /**
     * 获取：图片名称
     */
    public String getImgName() {
        return imgName;
    }
    /**
     * 设置：类型 0：不跳转，1：外链，2.分类子页面，3.商品列表页，4.商品
     */
    public void setImgType(Integer imgType) {
        this.imgType = imgType;
    }

    /**
     * 获取：类型 0：不跳转，1：外链，2.分类子页面，3.商品列表页，4.商品
     */
    public Integer getImgType() {
        return imgType;
    }
    /**
     * 设置：商品版本 0：旧版，1：新版
     */
    public void setImgVersion(Integer imgVersion) {
        this.imgVersion = imgVersion;
    }

    /**
     * 获取：商品版本 0：旧版，1：新版
     */
    public Integer getImgVersion() {
        return imgVersion;
    }
    /**
     * 设置：排序
     */
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    /**
     * 获取：排序
     */
    public Integer getSort() {
        return sort;
    }
    /**
     * 设置：跳转链接
     */
    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
    }

    /**
     * 获取：跳转链接
     */
    public String getLinkUrl() {
        return linkUrl;
    }
    /**
     * 设置：图片链接
     */
    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    /**
     * 获取：图片链接
     */
    public String getImgUrl() {
        return imgUrl;
    }
    /**
     * 设置：是否支持浏览
     */
    public void setScanFlag(Integer scanFlag) {
        this.scanFlag = scanFlag;
    }

    /**
     * 获取：是否支持浏览
     */
    public Integer getScanFlag() {
        return scanFlag;
    }
    /**
     * 设置：是否跳转
     */
    public void setRedirectFlag(Integer redirectFlag) {
        this.redirectFlag = redirectFlag;
    }

    /**
     * 获取：是否跳转
     */
    public Integer getRedirectFlag() {
        return redirectFlag;
    }
    /**
     * 设置：是否可用
     */
    public void setEnableFlag(Integer enableFlag) {
        this.enableFlag = enableFlag;
    }

    /**
     * 获取：是否可用
     */
    public Integer getEnableFlag() {
        return enableFlag;
    }
}
