package com.example.afrishop_v3.models;

import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;

/**
 * 实体
 * 表名 tb_cf_address
 *
 * @author G
 * @date 2019-08-16 15:51:16
 */
@Entity
@Data
@DynamicUpdate
public class TbCfAddress{


    @Id
    private String addressId;
    /**
     * 用户id
     */
    private String userId;
    /**
     * 姓
     */
    @Column(name = "first_name")
    private String  deliveryName;
    /**
     * 名
     */
    private String lastName;
    /**
     * 联系电话
     */
    private String phone;
    /**
     * 邮箱
     */
    private String email;
    /**
     * 是否为默认地址
     */
    private Integer defaultFlag;
    /**
     * 地址详情1
     */
    @Column(name = "address1")
    private String addressDetail;
    /**
     * 地址详情2
     */
    private String address2;
    /**
     * 国家
     */
    private String country;
    /**
     * 省
     */
    private String province;
    /**
     * 市
     */
    private String city;
    /**
     * 邮编
     */
    private String zipCode;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;


}
