package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.enums.ResultCodeEnum;
import com.example.afrishop_v3.models.*;
import com.example.afrishop_v3.repository.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.*;
import java.util.stream.Collectors;

@RestController
public class TbCfHomePageEntityController extends Controller {
    private final TbCfHomePageRepository repository;
    private final TbCfSortRepository sortRepository;
    private final TbCfClassificationRepository classificationRepository;
    private final TbCfStoreRepository storeRepository;
    private final TbCfPosterRepository posterRepository;
    private final TbCfColumnRepository columnRepository;
    private final UserRepository userRepository;
    private final VisitRepository visitRepository;
    private final PostRepository postRepository;
    private static Logger logger = LoggerFactory.getLogger(UploadController.class);

    public TbCfHomePageEntityController(TbCfHomePageRepository repository, TbCfSortRepository sortRepository, TbCfClassificationRepository classificationRepository, TbCfStoreRepository storeRepository, TbCfPosterRepository posterRepository, TbCfColumnRepository columnRepository, UserRepository userRepository, VisitRepository visitRepository, PostRepository postRepository) {
        this.repository = repository;
        this.sortRepository = sortRepository;
        this.classificationRepository = classificationRepository;
        this.storeRepository = storeRepository;
        this.posterRepository = posterRepository;
        this.columnRepository = columnRepository;
        this.userRepository = userRepository;
        this.visitRepository = visitRepository;
        this.postRepository = postRepository;
    }

    @GetMapping("/startPage/img")
    public Result<List<TbCfHomePage>> getStartPageImage(@RequestParam(value = "version", defaultValue = "0") Integer version) {
        List<TbCfHomePage> all = repository.getAllByImgVersionAndEnableFlag(version, 1);
        return new Result<>(all);
    }

    @GetMapping("/store")
    public Result getStores( @RequestParam(required = false,defaultValue = "0") Integer pageNum, @RequestParam(defaultValue = "10",required = false) Integer pageSize) {

        return new Result<>(storeRepository.findAll(PageRequest.of(pageNum,pageSize)));
    }

    //Fetch recommended items
    @GetMapping("home/listPosts/recommend")
    public List<Post> postList2(@RequestParam(value = "userId",required = false) String id, @RequestParam(value = "pageNo") Integer pageNo, @RequestParam(value = "pageSize") Integer pageSize) {

        //Optional<TbCfUserInfo> byId = userRepository.findById(id);
        //if( !byId.isPresent() ) return new ArrayList<>();
        return postRepository.findAllByOrderByCreateDateDesc(PageRequest.of(pageNo, pageSize)).toList();
    }



    private Visit visitPost(Post post) {
        Visit visit = new Visit();
        visit.setPost(post);
        return visitRepository.save(visit);
    }

    @GetMapping("/community/{postId}")
    public Post findPost(@PathVariable(value = "postId") String id) {
        Optional<Post> byId = postRepository.findById(id);
        if (byId.isPresent()) {
            Post post = byId.get();
            visitPost(post);
            //Retrieve all post related information this is important to increase community performance while serializing json
            post.retrieveAll = true;
            return post;
        }
        logger.info("Post not found");
        return null;
    }

    //List users who are eligible to receive firebase cloud messages to their devices
    @GetMapping("/home/clientWithFcm")
    public Result getClientList( @RequestParam(value = "pageNo",required = false,defaultValue = "20") Integer pageNo, @RequestParam(value = "pageSize",required = false,defaultValue = "20") Integer pageSize){
        List<TbCfUserInfo> allByFcmIsNotNull = userRepository.findAllByFcmIsNotNullOrderByLastLoginTimeDesc(PageRequest.of(pageNo, pageSize));
        //Map list to Small map to minimize amount of json serialized information
        return new Result<>(allByFcmIsNotNull.stream().map(TbCfUserInfo::smallMap).collect(Collectors.toList()));
    }

    //Send notification to the user by his code
    @GetMapping("/home/sendNotification/byCode/{code}")
    public Result sendFcm(@PathVariable("code") String id,@RequestParam("content") String content,@RequestParam("title") String title){
        Optional<TbCfUserInfo> byId = userRepository.findByCode(id);

        if( byId.isPresent() && byId.get().hasFcm() ){
            TbCfUserInfo userInfo = byId.get();
            sendNotification(userInfo.getFcm(),title,content);
            return new Result();
        }

        return new Result(ResultCodeEnum.SUCCESS.getCode(),"No firebase messaging token found");
    }

    @GetMapping("/home/middleColumn")
    public Result getMiddleColumn( @RequestParam(value = "limit", defaultValue = "4") Integer limit){
        Result result = new Result<>();
        try {
            List<TbCfSort> moduleList = sortRepository.findAll(Sort.by(Sort.Order.asc("sort")));
            List<Map<String, Object>> list = new ArrayList<>();
            if (moduleList != null && moduleList.size() > 0) {
                for (TbCfSort module : moduleList) {
                    Map<String, Object> moduleMap = new LinkedHashMap<>();
                    String type = String.valueOf(module.getType());
                    //分类导航栏
                    if ("1".equals(type)) {
                        /*moduleMap.put("class_title", getTitleImage(1));*/
                        List<TbCfClassification> classificationList = classificationRepository.findAll(Sort.by(Sort.Order.asc("sort")));
                        moduleMap.put("classificationList", classificationList);
                    }
                    //爬虫品牌
                    if ("2".equals(type)) {
                        moduleMap.put("store_title", getTitleImage(2));
                        List<TbCfStore> storeStationList = storeRepository.findAll(PageRequest.of(0,limit,Sort.by(Sort.Order.desc("enableFlag"),Sort.Order.desc("storeCode")))).toList();
                        moduleMap.put("storeStationList", storeStationList);
                    }
                    //海报图
                    if ("3".equals(type)) {
                        moduleMap.put("poster_title", getTitleImage(3));
                        List<TbCfPosters> postersList = posterRepository.findAll(Sort.by(Sort.Order.asc("sort")));
                        moduleMap.put("postersList", postersList);
                    }
                    list.add(moduleMap);
                }
                Map<String,Object> map = new HashMap<>();
                List<TbCfColumn> hotColumnList = columnRepository.findAllByColumnType(4);
                map.put("hot_title", hotColumnList);
                list.add(map);
                return new Result<>(list);
            }
        } catch (Exception e) {
            result.setCode(ResultCodeEnum.SERVICE_ERROR.getCode());
            result.setMessage(e.toString());
        }
        return result;
    }


    private List<TbCfColumn> getTitleImage(Integer type) {
        return columnRepository.findAllByColumnType(type);
    }
}
