package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.models.TbCfStationItem;
import com.example.afrishop_v3.repository.TbCfGoodstypeEntityRepository;
import com.example.afrishop_v3.repository.TbCfStationItemRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import static org.springframework.data.domain.Sort.Order.asc;
import static org.springframework.data.domain.Sort.Order.desc;

@RestController
@RequestMapping("/goodsType")
public class GoodsTypeController {
    private static Logger logger = LoggerFactory.getLogger(GoodsTypeController.class);

    private final TbCfGoodstypeEntityRepository repository;
    private final TbCfStationItemRepository itemRepository;

    public GoodsTypeController(TbCfGoodstypeEntityRepository repository, TbCfStationItemRepository itemRepository) {
        this.repository = repository;
        this.itemRepository = itemRepository;
    }

    @RequestMapping("/getGoodsTypeList")
    @GetMapping
    public Result getGoodsTypeList() {
        return new Result<>(repository.findAll());
    }

    @RequestMapping("/getItemStationList")
    @GetMapping
    public Result getItemStationList(@RequestParam(required = false) Integer pageNum,
                                     @RequestParam(required = false) Integer pageSize,
                                     @RequestParam(required = false) String categoryId,
                                     @RequestParam(required = false) String order
    ) {
        if (pageNum == null) {
            pageNum = 1;
        }
        if (pageSize == null) {
            pageSize = 6;
        }

        Page<TbCfStationItem> all;

        if (categoryId != null)
            all = itemRepository.findByItemCategory(categoryId, PageRequest.of(pageNum, pageSize, sort(order)));
        else
            all = itemRepository.findAll(PageRequest.of(pageNum, pageSize, sort(order)));

        return new Result<>(all);
    }


    private Sort sort(String order) {
        String col = "discountPrice";
        return Sort.by("desc".equals(order) ? desc(col) : asc(col));
    }
}
