package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.models.Following;
import com.example.afrishop_v3.models.TbCfUserInfo;
import com.example.afrishop_v3.repository.FollowRepository;
import com.example.afrishop_v3.repository.UserRepository;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/discover/follow")
public class FollowingController {
    private final FollowRepository repository;
    private final UserRepository userRepository;

    public FollowingController(FollowRepository repository, UserRepository userRepository) {
        this.repository = repository;
        this.userRepository = userRepository;
    }

    //List followed users by user id
    @GetMapping("listFollowers/{userId}")
    public List<TbCfUserInfo> getList(@PathVariable("userId") String id){
        return repository.findAllByFollowedInfoUserId(id).stream().map(Following::getFollowerInfo).collect(Collectors.toList());
    }

    //List following users by user id
    @GetMapping("listFollowing/{userId}")
    public List<TbCfUserInfo> getListFollowing(@PathVariable("userId") String id){
        return repository.findAllByFollowerInfoUserId(id).stream().map(Following::getFollowedInfo).collect(Collectors.toList());
    }

    //Follow action
    @GetMapping("follow/user/{follower}/{followed}/{status}")
    public Following followingStatus(@PathVariable("follower") String follower, @PathVariable("followed") String followed, @PathVariable("status") boolean status){
        Following following = new Following();
        Optional<TbCfUserInfo> optionalUser = userRepository.findById(followed);
        Optional<TbCfUserInfo> optionalUser0 = userRepository.findById(follower);
        optionalUser.ifPresent(following::setFollowedInfo);
        optionalUser0.ifPresent(following::setFollowerInfo);
        if( status ) {
            if(!repository.existsByFollowedInfoUserIdAndFollowerInfoUserId(followed,follower))
            repository.save(following);
        }else
            repository.removeByFollowed_IdAndFollower_Id(followed,follower);
        return following;
    }

    @GetMapping("follow/status/{follower}/{followed}")
    public boolean followStatus(@PathVariable("follower") String follower, @PathVariable("followed") String followed){
        return repository.existsByFollowedInfoUserIdAndFollowerInfoUserId(followed,follower);
    }


}
