package com.example.afrishop_v3.controllers;

import com.alibaba.fastjson.JSON;
import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.config.CardCharge;
import com.example.afrishop_v3.config.Environment;
import com.example.afrishop_v3.config.RaveConstant;
import com.example.afrishop_v3.enums.DeliveryStatusEnum;
import com.example.afrishop_v3.enums.OrderStatusEnum;
import com.example.afrishop_v3.enums.ResultCodeEnum;
import com.example.afrishop_v3.models.*;
import com.example.afrishop_v3.repository.*;
import com.example.afrishop_v3.security.services.AuthenticationUser;
import com.example.afrishop_v3.util.HttpClientUtil;
import com.example.afrishop_v3.util.IdUtil;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;

@RestController
@RequestMapping("/flutterwave")
public class FlutterWaveController extends Controller {
    private static Logger logger = LoggerFactory.getLogger(FlutterWaveController.class);
    private final TbCfOrderRepository repository;
    private final TbCfFinanceRepository financeRepository;
    private final UserRepository userRepository;
    // private final DomainProperties domainProperties;
    private final AuthenticationUser user;

    private final NetworkRepository networkRepository;
    private final BonusRepository bonusRepository;
    private final PostRepository postRepository;
    private final TbCfOrderRepository orderRepository;

    @Value("${flutter.refund_url}")
    private String FLUTTERWAVE_REFUND_URL;

    //校验API
    @Value("${flutter.pay_url}")
    private String VERIFY_PAY_URL;

    @Value("${flutter.public_key}")
    private String PUBLIC_KEY;

    @Value("${flutter.secret_key}")
    private String SECRET_KEY;

    @Value("${flutter.redirect_url}")
    private String REDIRECT_URL;


//    //退款API
//    private String FLUTTERWAVE_REFUND_URL = "https://api.ravepay.co/gpx/merchant/transactions/refund";
//
//    //    //校验API
//    private String VERIFY_PAY_URL = "https://api.ravepay.co/flwv3-pug/getpaidx/api/v2/verify";

    public FlutterWaveController(TbCfOrderRepository repository, TbCfFinanceRepository financeRepository, UserRepository userRepository, AuthenticationUser user, NetworkRepository networkRepository, BonusRepository bonusRepository, PostRepository postRepository, TbCfOrderRepository orderRepository) {
        this.repository = repository;
        this.financeRepository = financeRepository;
        this.userRepository = userRepository;
        // this.domainProperties = domainProperties;
        this.user = user;
        this.networkRepository = networkRepository;
        this.bonusRepository = bonusRepository;
        this.postRepository = postRepository;
        this.orderRepository = orderRepository;
    }

    @PostMapping("/pay")
    public ResponseEntity<String> payForOrderByCard(@RequestParam("orderId") String orderId, @RequestBody FlutterWaveCard flutterWaveCard) {
        RaveConstant.PUBLIC_KEY = PUBLIC_KEY;
        RaveConstant.SECRET_KEY = SECRET_KEY;
        RaveConstant.ENVIRONMENT = Environment.STAGING; //or live
        // Result result = new Result();
        Optional<TbCfOrder> byId = repository.findById(orderId);


        JSONObject json = new JSONObject();


        if (byId.isPresent()) {

            //TbCfOrderVo tbCfOrderVo = (TbCfOrderVo) orderRedisCache.get(KeyConstant.ORDER_DET + orderId);
            TbCfOrder orderEntity = byId.get();
            //判断这个订单是否已支付
            if (OrderStatusEnum.PAID.getValue().equals(orderEntity.getPayStatus())) {
                json.put("message", "Order paid!");
                json.put("code", ResultCodeEnum.ORDER_PAY_ERROR.getCode());
            } else {
                try {
                    String orderPrice = orderEntity.getRealityPay().toString();
                    CardCharge ch = new CardCharge();
                    ch.setCardno(flutterWaveCard.getCard())
                            .setCvv(flutterWaveCard.getCvv())
                            .setCurrency("USD")
                            .setCountry("NG")
                            .setAmount(orderPrice)
                            .setRedirect_url(REDIRECT_URL + "/" + orderId)
                            .setExpiryyear(flutterWaveCard.getYear())
                            .setExpirymonth(flutterWaveCard.getMonth())
                            .setEmail(flutterWaveCard.getEmail())
                            .setTxRef(orderId);
                    JSONObject chargevisa = ch.chargeVisaAndIntl();
                    JSONObject object = chargevisa.getJSONObject("data");
                    boolean b = object != null && object.has("authurl");

                    String message = !b && object != null && object.has("message") ? object.getString("message") : ResultCodeEnum.SERVICE_ERROR.getDesc();

                    json.put("data", chargevisa);
                    json.put("code", b ? ResultCodeEnum.SUCCESS.getCode() : ResultCodeEnum.SERVICE_ERROR.getCode());
                    json.put("message", b ? ResultCodeEnum.SUCCESS.getDesc() : message);
                } catch (Exception e) {
                    json.put("code", ResultCodeEnum.ORDER_PAY_ERROR.getCode()).put("message", e.getMessage());
                    logger.error(e.getMessage(), e);
                }
            }
        }

        return new ResponseEntity<>(json.toString(), HttpStatus.OK);
    }


    @PostMapping("/payMobile")
    public ResponseEntity<String> payForOrderByPhone(@RequestParam("orderId") String orderId, @RequestBody FlutterWaveCard flutterWaveCard) {
        RaveConstant.PUBLIC_KEY = PUBLIC_KEY;
        RaveConstant.SECRET_KEY = SECRET_KEY;
        RaveConstant.ENVIRONMENT = Environment.STAGING; //or live
        // Result result = new Result();
        Optional<TbCfOrder> byId = repository.findById(orderId);


        JSONObject json = new JSONObject();


        if (byId.isPresent()) {

            //TbCfOrderVo tbCfOrderVo = (TbCfOrderVo) orderRedisCache.get(KeyConstant.ORDER_DET + orderId);
            TbCfOrder orderEntity = byId.get();
            //判断这个订单是否已支付
            if (OrderStatusEnum.PAID.getValue().equals(orderEntity.getPayStatus())) {
                json.put("message", "Order paid!");
                json.put("code", ResultCodeEnum.ORDER_PAY_ERROR.getCode());
            } else {
                try {
                    CardCharge ch = new CardCharge();
                    ch.setCardno(flutterWaveCard.getCard())
                            .setCvv(flutterWaveCard.getCvv())
                            .setCurrency("ZMW")
                            .setCountry("NG")
                            .setAmount(orderEntity.getRealityPay().toString())
                            .setRedirect_url(REDIRECT_URL + "/" + orderId)
                            .setExpiryyear(flutterWaveCard.getYear())
                            .setExpirymonth(flutterWaveCard.getMonth())
                            .setPhonenumber(flutterWaveCard.getPhone())
                            .setEmail(flutterWaveCard.getEmail())
                            .setTxRef(orderId);
                    JSONObject chargevisa = ch.chargeMobileMoney();
                    JSONObject object = chargevisa.getJSONObject("data");
                    boolean b = object != null && object.has("authurl");

                    String message = !b && object != null && object.has("message") ? object.getString("message") : ResultCodeEnum.SERVICE_ERROR.getDesc();

                    json.put("data", chargevisa);
                    json.put("code", b ? ResultCodeEnum.SUCCESS.getCode() : ResultCodeEnum.SERVICE_ERROR.getCode());
                    json.put("message", b ? ResultCodeEnum.SUCCESS.getDesc() : message);
                } catch (Exception e) {
                    json.put("code", ResultCodeEnum.ORDER_PAY_ERROR.getCode()).put("message", e.getMessage());
                    logger.error(e.getMessage(), e);
                }
            }
        }

        return new ResponseEntity<>(json.toString(), HttpStatus.OK);
    }


    @GetMapping("/notify/{orderId}")
    public Result verifyFromFlutter(@PathVariable("orderId") String orderId) {
        return verifyPay(orderId);
    }

    /**
     * 验证付款
     *
     * @param
     * @param orderId
     * @return
     */
    @PostMapping("/verifyPay")
    public Result verifyPay(@RequestParam("orderId") String orderId) {
        Result result = new Result();
        try {
            logger.info("订单号" + orderId + "[flutterwave支付]校验开始时间：" + new Date());

            Optional<TbCfOrder> byId = repository.findById(orderId);

            if (!byId.isPresent()) return new Result(ResultCodeEnum.SERVICE_ERROR.getCode(), "Order not found !");

            TbCfOrder tbCfOrderVo = byId.get();
            Map<String, Object> map = new HashMap<>();
            map.put("txref", orderId);
            map.put("SECKEY", SECRET_KEY);
            String data = HttpClientUtil.sendPostWithBodyParameter(VERIFY_PAY_URL, map);
            com.alibaba.fastjson.JSONObject object = JSON.parseObject(data);
            String statusFlag = object.getString("status");
            com.alibaba.fastjson.JSONObject results = object.getJSONObject("data");
            String status = results.getString("status");
            String paymentid = results.getString("paymentid");
            String authurl = results.getString("authurl");
            if ("success".equalsIgnoreCase(statusFlag) && "successful".equalsIgnoreCase(status)) {
                TbCfUserInfo user = this.user.user();
                if (user.hasFcm()) {
                    sendNotification(user.getFcm(), "Order alert !!", "Order of $" + tbCfOrderVo.getRealityPay() + " has been successfully paid !!");
                }
                logger.info("订单号" + orderId + "[flutterwave支付]校验成功时间：" + new Date());
                //支付成功
                changeOrderState(paymentid, tbCfOrderVo);
                //修改优惠券状态

                   /* if (!StringUtils.isBlank(tbCfOrderVo.getCouponId())) {
                        tbCfToiCouponDao.changeCoupnStatus(tbCfOrderVo.getUserId(), tbCfOrderVo.getCouponId());
                    }*/
                //生成支付流水
                TbCfFinance finance = createFinance(paymentid, authurl, tbCfOrderVo);

                //生成佣金
                Optional<TbCfOrder> optional = orderRepository.findById(orderId);
                if (optional.isPresent()) {
                    TbCfOrder tbCfOrder = optional.get();
                    Bonus bonus = new Bonus();
                    TbCfUserInfo userInfo = new TbCfUserInfo();
                    userInfo.setUserId(tbCfOrder.getUserId());
//                        bonus.setUserId(tbCfOrder.getUserId());
                    bonus.setOrderId(orderId);
                    bonus.setAmount(tbCfOrder.getItemsPrice());

                    System.out.println("佣金-----》》》订单号：" + orderId + "=user=" + tbCfOrder.getUserId() + "=price=" + tbCfOrder.getItemsPrice());
                    saveNetworkMarketing(bonus, tbCfOrder.getUserId());
                }
//                TbCfFinanceVo tbCfFinanceVo = new TbCfFinanceVo();
//                BeanUtils.copyProperties(finance, tbCfFinanceVo);
//                removeRedisCache(tbCfOrderVo);
                result.setData(JSON.parseObject(data));
                result.setCode(ResultCodeEnum.SUCCESS.getCode()).setMessage("payment success!");
                logger.info("payment success!");
                //清空订单
                logger.info("订单号" + orderId + "[flutterwave支付]校验结束时间：" + new Date());
            } else {
                result.setData(JSON.parseObject(data));
                //支付失败
                result.setCode(ResultCodeEnum.ORDER_PAY_ERROR.getCode()).setMessage("payment failure!");
                logger.error("payment failure!");
                logger.info("订单号" + orderId + "[flutterwave支付]校验失败时间：" + new Date());
            }
        } catch (Exception e) {
            result.setCode(ResultCodeEnum.VALIDATE_ERROR.getCode()).setMessage(e.getMessage());
            logger.error(e.getMessage(), e);
            return result;
        }
        return result;
    }


    private void changeOrderState(String payId, TbCfOrder order) {
        //更改订单状态
        order.setUpdateTime(new Date());
        order.setDealTime(new Date());
        order.setPayId(payId);
        order.setOrderStatus(OrderStatusEnum.PAID.getValue());
        order.setPayStatus(OrderStatusEnum.PAID.getValue());
        order.setDeliveryFlag(DeliveryStatusEnum.PROCESSING.getValue());
        repository.save(order);
    }

    private TbCfFinance createFinance(String paymentId, String url, TbCfOrder tbCfOrderVo) {
        TbCfFinance tbCfFinance = new TbCfFinance();
        tbCfFinance.setOrderId(tbCfOrderVo.getOrderId());
        tbCfFinance.setFinaceId(IdUtil.createIdbyUUID());
        tbCfFinance.setPayAccount(tbCfOrderVo.getRealityPay());
        tbCfFinance.setPayId(paymentId);
        tbCfFinance.setPayTime(new Date());
        tbCfFinance.setReceiptUrl(url);
        tbCfFinance.setPayWayCode("flutterwave");
        tbCfFinance.setUserId(tbCfOrderVo.getUserId());
        financeRepository.save(tbCfFinance);
        return tbCfFinance;
    }

    /**
     * 退款
     *
     * @param flutterWaveCard
     * @return
     */
    @PostMapping("/refund")
    public Result refund(@RequestBody FlutterWaveCard flutterWaveCard) {
        Result result = new Result();
        RaveConstant.SECRET_KEY = SECRET_KEY;
        Map<String, Object> params = new HashMap<>();
        params.put("ref", flutterWaveCard.getRef());
        params.put("seckey", RaveConstant.SECRET_KEY);
        if (flutterWaveCard.getAmount() != null) {
            params.put("amount", flutterWaveCard.getAmount());
        }
        try {
            String post = HttpClientUtil.sendPostWithBodyParameter(FLUTTERWAVE_REFUND_URL, params);
            com.alibaba.fastjson.JSONObject object = JSON.parseObject(post);
            String status = object.getString("status");
            if ("success".equals(status)) {
                result.setData(object).setMessage("Refund success!");
                logger.info("Refund success!");
            } else {
                result.setCode(ResultCodeEnum.REFUND_PAY_ERROR.getCode()).setMessage("Refund failure!");
            }
        } catch (IOException e) {
            result.setCode(ResultCodeEnum.REFUND_PAY_ERROR.getCode()).setMessage(e.getMessage());
            logger.error(e.getMessage(), e);
            return result;
        }
        return result;
    }

    /**
     * 支付参数
     *
     * @param userId
     * @return
     */
    @GetMapping("/queryParams")
    public Result queryParams(@RequestParam("userId") String userId) {

        Optional<TbCfUserInfo> byId = userRepository.findById(userId);

        if (!byId.isPresent()) return new Result();

        TbCfUserInfo userInfo = byId.get();

        Result result = new Result<>();
        List<TbCfUserInfo> list = new ArrayList<>();
        FlutterKey key = new FlutterKey();
        String public_key = PUBLIC_KEY;

        list.add(userInfo);
        key.setPublic_key(public_key);
        key.setUserInfo(list);
        result.setData(key).setMessage(ResultCodeEnum.SUCCESS.getDesc());
        return result;
    }

    public void saveNetworkMarketing(Bonus bonus, String userId) {

        String orderId = bonus.getOrderId();

        if (orderId == null)
            logger.info("佣金：orderId为空");

        Optional<TbCfOrder> orderOptional = orderRepository.findById(orderId);

        if (!orderOptional.isPresent())
            logger.info("佣金：订单不存在");

        TbCfOrder order = orderOptional.get();

        if (!OrderStatusEnum.PAID.getValue().equals(order.getPayStatus())) {
            logger.info("佣金：订单未支付");
        }

        boolean condition = orderId != null && orderOptional.isPresent() && OrderStatusEnum.PAID.getValue().equals(order.getPayStatus()) && !StringUtils.isBlank(userId);

//        if (bonusRepository.existsByOrderId(orderId)) {
//            return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(), "Transaction already done !!!");
//        }


        BigDecimal amount = bonus.getAmount();

        if (condition) {


            Optional<TbCfUserInfo> optionalUser = userRepository.findById(userId);

            if (optionalUser.isPresent()) {

                TbCfUserInfo user = optionalUser.get();

                Post post = bonus.getPost();

                Optional<Post> postOptional = post == null ? Optional.empty() : postRepository.findById(post.getId());

                String productSharer = bonus.getProductSharer();

                Optional<TbCfUserInfo> sharer = Optional.empty();

                if (productSharer != null) {
                    sharer = userRepository.findByCode(productSharer);
                }
                synchronized (this) {
                    boolean exists = bonusRepository.existsByOrderId(orderId);
                    if (!exists && user.invited()) {
                        BigDecimal v = amount.multiply(BigDecimal.valueOf(10)).divide(BigDecimal.valueOf(100), RoundingMode.CEILING);
                        bonus.setAmount(v);
                        bonus.setUserInfo(user);
                        bonus.setPercentage(10);
                        bonus = bonusRepository.save(bonus);
                        if (user.hasFcm()) {
                            sendNotification(user.getFcm(), "Bonus alert !!", user.display() + ", You received bonus of $" + formatter.format(v) + " in your account");
                        }
                    }

                    TbCfUserInfo bonusInc = runBonusInc(user, amount, 5, false, orderId);
                    runBonusInc(sharer.orElseGet(() -> postOptional.isPresent() ? postOptional.get().getRealUser() : bonusInc), amount, 5, postOptional.isPresent() || sharer.isPresent(), orderId);
                    //runBonusInc(bonusInc, amount, 0);
                }
            }

        }


    }

    private TbCfUserInfo runBonusInc(TbCfUserInfo user, BigDecimal amount, int percent, boolean direct, String orderId) {
        if (user == null) return null;
        Optional<Network> userCode = networkRepository.findFirstByNetworkInfoCode(user.getCode());
        if (userCode.isPresent() || direct) {
            TbCfUserInfo userInfo = direct ? user : userCode.get().getUserInfo();
            Bonus bonus = new Bonus();
            bonus.setUserInfo(userInfo);
            BigDecimal v = amount.multiply(BigDecimal.valueOf(percent));
            v = v.divide(BigDecimal.valueOf(100), RoundingMode.CEILING);
            bonus.setAmount(v);
            bonus.setPercentage(percent);
            bonus.setOrderId(orderId);
            if (userInfo != null && userInfo.invited() && !"000000".equals(userInfo.getCode())) {
                bonusRepository.save(bonus);
//                bonus = repository.save(bonus);
                if (userInfo.hasFcm()) {
                    sendNotification(userInfo.getFcm(), "Bonus alert !!", userInfo.display() + ", You received bonus of $" + formatter.format(v) + " in your account");
                }
            }
            return userInfo;
        }

        return null;
    }
}
