package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.models.CommentLike;
import com.example.afrishop_v3.repository.CommentLikeRepository;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/discover/comment/like")
public class CommentLikeController {
    private final CommentLikeRepository repository;

    public CommentLikeController(CommentLikeRepository repository) {
        this.repository = repository;
    }


    @PostMapping(value ="/saveCommentLike/{liked}")
    public CommentLike saveCommentLike(@PathVariable("liked") boolean liked, @ModelAttribute("CommentLike") CommentLike like){
        //Like status for determine whether to like or dislike
        if( liked )
        return repository.save(like);
        else{
            repository.removeByComment_Id(like.commentId());
            return  null;
        }
    }



    @GetMapping(value = "/CommentsLikesByCommentId/{commentId}")
    //@PreAuthorize("hasAuthority('ADMIN_USER') or hasAuthority('STANDARD_USER')")
    public List<CommentLike> getList(@PathVariable(value = "commentId") String id, @RequestParam(value = "pageNo") Integer pageNo, @RequestParam(value = "pageSize") Integer pageSize) {
        return repository.findAllByCommentId(id, PageRequest.of(pageNo, pageSize)).toList();
    }
}
