package com.example.afrishop_v3.website.controller;


import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.models.TbCfDescripiton;
import com.example.afrishop_v3.models.TbCfGoodstwotype;
import com.example.afrishop_v3.models.TbCfGoodstype;
import com.example.afrishop_v3.models.TbCfStationItem;
import com.example.afrishop_v3.repository.TbCfDescripitonRepository;
import com.example.afrishop_v3.repository.TbCfGoodstwotypeRepository;
import com.example.afrishop_v3.repository.TbCfGoodstypeRepository;
import com.example.afrishop_v3.repository.TbCfStationItemRepository;
import com.example.afrishop_v3.vo.Category;
import com.example.afrishop_v3.vo.StationToGoodsType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.*;

/**
 * @Auther: wudepeng
 * @Date: 2020/11/23
 * @Description:PC官网首页内容管理
 */
@RestController
@RequestMapping(value = "/website")
public class ColumnController {

    private final TbCfGoodstypeRepository repository;

    private final TbCfGoodstwotypeRepository secondaryRepository;

    private final TbCfDescripitonRepository tertiaryRepository;

    private final TbCfStationItemRepository itemRepository;

    public ColumnController(TbCfGoodstypeRepository repository, TbCfGoodstwotypeRepository secondaryRepository, TbCfDescripitonRepository tertiaryRepository, TbCfStationItemRepository itemRepository) {
        this.repository = repository;
        this.secondaryRepository = secondaryRepository;
        this.tertiaryRepository = tertiaryRepository;
        this.itemRepository = itemRepository;
    }

    /**
     * 查询所有一级分类
     */
    @GetMapping("/column")
    public Result findTopCategory() {

        return new Result<>(repository.findAll());
    }

    /**
     * 查询一级分类的子分类
     */
    @GetMapping("/column/{id}")
    public Result findCategoryChildrens(@PathVariable("id") String id) {
        LinkedList<Category> categoryList = new LinkedList<>();

        //二级分类
        List<TbCfGoodstwotype> secondaryCategory = secondaryRepository.findAllByGoodstypeIdOrderBySort(id);

        secondaryCategory.forEach(category -> {
            //三级分类
            List<TbCfDescripiton> tertiaryCategory = tertiaryRepository.findAllByGoodstwotypeIdOrderBySort(category.getGoodstwotypeId());
            Category c = new Category();
            c.setId(category.getGoodstwotypeId());
            c.setCategory(category.getGoodstwotypeTitle());
            c.setCategoryList(tertiaryCategory);
            categoryList.add(c);
        });

        return new Result<>(categoryList);
    }


    /**
     * 首页商品分类商品展示（每个分类展示4个）
     */
    @GetMapping("/findItemByCategory")
    public Result findItemByCategory() {
        List<StationToGoodsType> listStation = new ArrayList<>();
        Iterable<TbCfGoodstype> list = repository.findAll();
        for (TbCfGoodstype goods : list) {
            StationToGoodsType goodsType = new StationToGoodsType();
            goodsType.setCategoryId(goods.getGoodstypeId());
            goodsType.setGoodstypetitle(goods.getGoodstypeTitle());
            goodsType.setGoodstypeUrl(goods.getGoodstypeUrl());
            List<TbCfStationItem> station = itemRepository.findTop4ByItemCategoryOrderByCreateTime(goods.getGoodstypeId());
            goodsType.setStationlist(station);
            listStation.add(goodsType);
        }
        return new Result<>(listStation);
    }


}
