package com.example.afrishop_v3.web.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.models.TbCfHomePage;
import com.example.afrishop_v3.repository.TbCfHomePageRepository;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/website/banner")
public class BannerController {
    private final TbCfHomePageRepository repository;

    public BannerController(TbCfHomePageRepository repository) {
        this.repository = repository;
    }

    @GetMapping
    public Result getBannerList(@RequestParam(value = "version") Integer version) {
        List<TbCfHomePage> list = repository.getAllByImgVersionAndEnableFlag(version, 1);

        return new Result<>(list);
    }
}
