package com.example.afrishop_v3.repository;

import com.example.afrishop_v3.inter_face.CommentCount;
import com.example.afrishop_v3.models.TbCfItemComment;
import com.example.afrishop_v3.models.TbCfUserInfo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.query.Param;

public interface TbCfItemCommentRepository extends PagingAndSortingRepository<TbCfItemComment,String> {
    boolean existsByUserUserIdAndItemId(String userId, String itemId);
    Page<TbCfItemComment> findAllByItemId(String itemId, Pageable pageable);
    @Query("select a as itemComment, count(x) as commented from #{#entityName} a left join TbCfItemLike x on a=x.comment and x.user=:user where a.itemId=:itemId group by a")
    Page<CommentCount> findAllByItemIdAndUser(@Param("itemId") String itemId, @Param("user") TbCfUserInfo user, Pageable pageable);
}
