package com.example.afrishop_v3.repository;

import com.example.afrishop_v3.models.Following;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface FollowRepository extends CrudRepository<Following,String> {
    List<Following> findAllByFollowedInfoUserId(String followedInfo_userId);
    List<Following> findAllByFollowerInfoUserId(String followerInfo_userId);

    boolean existsByFollowedInfoUserIdAndFollowerInfoUserId(String followedInfo_userId, String followerInfo_userId);


    @Query(value = "delete from following WHERE followed_info_user_id=:id1 and follower_info_user_id=:id2",nativeQuery = true)
    @Modifying
    @Transactional
    void removeByFollowed_IdAndFollower_Id(@Param("id1") String followed_id, @Param("id2") String follower_id);
}
