package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.enums.ResultCodeEnum;
import com.example.afrishop_v3.util.HttpClientUtil;
import com.example.afrishop_v3.util.OssUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

/**
 * @Auther: wudepeng
 * @Date: 2020/01/09
 * @Description:文件上传API
 */

@RestController
@RequestMapping("/api/upload")
public class UploadController {

    @Value("${upload.api}")
    private String api;
    private static Logger logger = LoggerFactory.getLogger(UploadController.class);

    @PostMapping("/uploadFile")
    public Result uploadFile(@RequestBody String strImg) throws Exception {
        Result<String> result = new Result<>();
        String url = sendFile(strImg,api);

        result.setData(url).setMessage(ResultCodeEnum.SUCCESS.getDesc());
        return result;
    }

    private static String sendFile(String strImg,String api){

        try {
            if (!StringUtils.isBlank(strImg)) {
                Map<String,Object> map = new HashMap<>();
                map.put("file", strImg);
                String url = HttpClientUtil.sendPostWithBodyParameter(api, map);
                return url.substring(1, url.length() - 1);
            } else {
                logger.info("Null Image");
                return null;
            }
        } catch (Exception e) {
            logger.info(e.getMessage());
            return null;
        }
    }

    //@ApiOperation("删除文件")
    @DeleteMapping("/delFile")
    public Result delFile(@RequestParam("url") String url) {
        Result<Map<String,Object>> result = new Result<>();
        Map<String,Object> map = new HashMap<>();
        boolean b = OssUtil.deleteFile(url);
        map.put("isDeleted", b);
        result.setData(map).setMessage(ResultCodeEnum.SUCCESS.getDesc());
        return result;
    }

}
