package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.enums.ResultCodeEnum;
import com.example.afrishop_v3.models.TbCfSearch;
import com.example.afrishop_v3.repository.TbCfSearchRepository;
import com.example.afrishop_v3.security.services.AuthenticationUser;
import com.example.afrishop_v3.util.IdUtil;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.List;
import java.util.Optional;

@RestController
@RequestMapping("/search")
public class SearchController {
    private final TbCfSearchRepository repository;

    private final AuthenticationUser user;

    public SearchController(TbCfSearchRepository repository, AuthenticationUser authenticationUser) {
        this.repository = repository;
        this.user = authenticationUser;
    }

    @PostMapping("/save")
    public Result save(@RequestBody TbCfSearch tbCfSearch) {
        //NotNull body is required
        if (tbCfSearch == null)
            return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(), "Empty body !");

        String searchKeywords = tbCfSearch.getSearchKeywords();
        //Keyword is also required
        if (searchKeywords == null || searchKeywords.trim().isEmpty())
            return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(), "Empty search keyword !");
        //Remove trailing spaces
        searchKeywords = searchKeywords.trim();

        String userId = user.userId();

        Optional<TbCfSearch> optional = repository.findFirstBySearchKeywordsAndUserId(searchKeywords, userId);
        //Replace db object if found
        tbCfSearch = optional.orElse(tbCfSearch);


        tbCfSearch.setCreateTime(new Date());


        if (!optional.isPresent())
            tbCfSearch.setId(IdUtil.createIdbyUUID());

        tbCfSearch.setUserId(userId);

        TbCfSearch entity = repository.save(tbCfSearch);

        return new Result<>(entity);
    }

    @GetMapping("/getRecords")
    public Result getRecords() {
        List<TbCfSearch> list = repository.getAllByUserIdOrderByCreateTimeDesc(user.userId());
        return new Result<>(list);
    }
    //Delete items by collections of ids
    @DeleteMapping("/deleteRecords")
    public Result deleteRecords(@RequestBody String[] ids) {
        if (ids != null) {
            repository.deleteAllByIdInAndUserId(ids, user.userId());
            return new Result();
        }
        return new Result(ResultCodeEnum.SERVICE_ERROR.getCode(),
                ResultCodeEnum.SERVICE_ERROR.getDesc());
    }
    //Empty entire user search history
    @DeleteMapping("/cleanSearch")
    public Result deleteRecords() {
        repository.deleteAllByUserId(user.userId());
        return new Result();
    }
}
