package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.models.TbCfCube;
import com.example.afrishop_v3.models.TbCfStationItem;
import com.example.afrishop_v3.repository.TbCfCubeRepository;
import com.example.afrishop_v3.repository.TbCfStationItemRepository;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @Auther: wudepeng
 * @Date: 2020/07/07
 * @Description:魔方管理类
 */
//@Api(value = "cubeController", description = "魔方管理")
@RestController
@RequestMapping("/cube")
public class CubeController {

    private final TbCfCubeRepository cubeRepository;
    private final TbCfStationItemRepository itemRepository;

    public CubeController(TbCfCubeRepository cubeRepository, TbCfStationItemRepository itemRepository) {
        this.cubeRepository = cubeRepository;
        this.itemRepository = itemRepository;
    }

    //获取所有的魔方
    //返回所有魔方的商品信息
    @GetMapping
    public Result getAllCubeItems() {
        Iterable<TbCfCube> all = cubeRepository.findAll();

        all.forEach(v->{
            String itemIds = v.getItemIds();
            if( itemIds != null){
                String[] split = itemIds.split(";");
                if(split.length > 0){
                    List<TbCfStationItem> allByItemIdIn = itemRepository.findAllByItemIdIn(split);
                    v.setItemList(allByItemIdIn);
                }
            }
        });

        return new Result<>(all);
    }
}
