package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.models.AttributesDesc;
import com.example.afrishop_v3.models.AttributesVo;
import com.example.afrishop_v3.models.TbCfItemParam;
import com.example.afrishop_v3.repository.AttributesDescRepository;
import com.example.afrishop_v3.repository.AttributesRepository;
import com.example.afrishop_v3.repository.TbCfItemParamRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Auther: wudepeng
 * @Date: 2020/12/29
 * @Description:属性管理
 */
@RestController
@RequestMapping("/attributes")
public class AttributesController {


    private final TbCfItemParamRepository itemParamRepository;
    private final AttributesRepository attributesRepository;
    private final AttributesDescRepository attributesDescRepository;

    public AttributesController(TbCfItemParamRepository itemParamRepository, AttributesRepository attributesRepository, AttributesDescRepository attributesDescRepository) {
        this.itemParamRepository = itemParamRepository;
        this.attributesRepository = attributesRepository;
        this.attributesDescRepository = attributesDescRepository;
    }

    @GetMapping("/getItemAttributesById/{itemId}")
    public Result getItemAttributesById(@PathVariable("itemId") String itemId) {
        List<TbCfItemParam> list = itemParamRepository.findAllByItemId(itemId);
        List<TbCfItemParam> collect = list.stream().filter(p -> StringUtils.isNotBlank(p.getAttrId())
                && StringUtils.isNotBlank(p.getAttrDescId())).collect(Collectors.toList());

        List<AttributesVo> attributesVos = new ArrayList<>();
        if (collect.size() > 0 && collect != null) {
            collect.forEach(p -> {
                AttributesVo attributesVo = new AttributesVo();
                attributesVo.setAttrName(attributesRepository.findById(p.getAttrId()).get().getAttrName());
                List<AttributesDesc> descs = attributesDescRepository.findByAttrDescIdIn(p.getAttrDescId().split(","));
                String descValue = descs.stream().map(AttributesDesc::getAttrValue).collect(Collectors.joining(","));
                attributesVo.setAttrValue(descValue);
                attributesVos.add(attributesVo);
            });
        }

        return new Result(attributesVos);
    }

}
