package com.example.afrishop_v3.models;

import lombok.Data;
import org.hibernate.annotations.Where;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Transient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 魔方实体
 * 表名 tb_cf_cube
 *
 * @author lipengjun
 * @date 2020-07-07 10:40:24
 */
@Entity
@Data
@Where(clause = "is_enabled=1")
public class TbCfCube {

    /**
     * 魔方ID
     */
    @Id
    private String id;
    /**
     * 魔方标题
     */
    private String cubeTitle;
    /**
     * 标题图片
     */
    private String headerImage;
    /**
     * 商品ID集合
     */
    private String itemIds;
    /**
     * 排序
     */
    private Integer sort;
    /**
     * 是否启用 0：不启用 1：启用
     */
    private Integer isEnabled;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;

    @Transient
    private List<TbCfStationItem> itemList = new ArrayList<>();

    /**
     * 设置：魔方ID
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * 获取：魔方ID
     */
    public String getId() {
        return id;
    }

    public void setItemList(List<TbCfStationItem> itemList) {
        this.itemList = itemList;
    }

    /**
     * 设置：魔方标题
     */
    public void setCubeTitle(String cubeTitle) {
        this.cubeTitle = cubeTitle;
    }

    /**
     * 获取：魔方标题
     */
    public String getCubeTitle() {
        return cubeTitle;
    }
    /**
     * 设置：标题图片
     */
    public void setHeaderImage(String headerImage) {
        this.headerImage = headerImage;
    }

    /**
     * 获取：标题图片
     */
    public String getHeaderImage() {
        return headerImage;
    }
    /**
     * 设置：商品ID集合
     */
    public void setItemIds(String itemIds) {
        this.itemIds = itemIds;
    }

    /**
     * 获取：商品ID集合
     */
    public String getItemIds() {
        return itemIds;
    }
    /**
     * 设置：排序
     */
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    /**
     * 获取：排序
     */
    public Integer getSort() {
        return sort;
    }
    /**
     * 设置：是否启用 0：不启用 1：启用
     */
    public void setIsEnabled(Integer isEnabled) {
        this.isEnabled = isEnabled;
    }

    /**
     * 获取：是否启用 0：不启用 1：启用
     */
    public Integer getIsEnabled() {
        return isEnabled;
    }
    /**
     * 设置：创建时间
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取：创建时间
     */
    public Date getCreateTime() {
        return createTime;
    }
    /**
     * 设置：更新时间
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 获取：更新时间
     */
    public Date getUpdateTime() {
        return updateTime;
    }
}
