package com.example.afrishop_v3.security.services;

import com.example.afrishop_v3.models.TbCfUserInfo;
import com.example.afrishop_v3.repository.UserRepository;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class AuthenticationUser implements IAuthenticationFacade {
     private final UserRepository repository;


    public AuthenticationUser(UserRepository repository) {
        this.repository = repository;
    }

    @Override
    public Authentication getAuthentication() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    public TbCfUserInfo user(){
        String name = getAuthentication().getName();
        return repository.findFirstByFirebaseUidOrAccount(name,name).orElseGet(null);
    }

    public String userId(){
        return user().getUserId();
    }
}
