package com.example.afrishop_v3.repository;

import com.example.afrishop_v3.models.TbCfToicoupon;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.query.Param;

import java.util.List;

public interface TbCfToicouponRepository extends PagingAndSortingRepository<TbCfToicoupon,String> {
    @Query("select a from #{#entityName} a WHERE a.enableFlag = 1 and a.userId = :user_id and CURRENT_TIMESTAMP between a.startTime and a.endTime order by a.coupon.deductAmount desc ")
    List<TbCfToicoupon> queryUserAvailableCoupon(@Param("user_id") String userId);

    @Query("select a from #{#entityName} a WHERE a.enableFlag = 0 and a.userId = :user_id order by a.coupon.deductAmount desc ")
    List<TbCfToicoupon> queryUserUsedCoupon(@Param("user_id") String userId);

    @Query("select a from #{#entityName} a WHERE a.enableFlag = 1 and a.userId = :user_id and CURRENT_TIMESTAMP not between a.startTime and a.endTime order by a.coupon.deductAmount desc ")
    List<TbCfToicoupon> queryUserExpiredCoupon(@Param("user_id") String userId);
}
