package com.example.afrishop_v3.repository;

import com.example.afrishop_v3.inter_face.OrderCount;
import com.example.afrishop_v3.models.TbCfOrder;
import com.example.afrishop_v3.models.TbCfUserInfo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.query.Param;

import java.util.Date;
import java.util.List;

public interface TbCfOrderRepository extends PagingAndSortingRepository<TbCfOrder,String> {
    @Query("select a as order,(select count(x) from TbCfItemComment x where x.orderId=a.orderId and x.user=:user) as commented from #{#entityName} a where a.userId=:userId")
    Page<OrderCount> findAllByUserId(@Param("userId") String userId, @Param("user") TbCfUserInfo user, Pageable pageable);
//    @Query(value = "select a from #{#entityName} a where :now >  DATE_SUB(a.orderTime,interval -1 day) and order_status=10")
//    List<TbCfOrder> getTimeoutOrders(@Param("now") Date date);

    List<TbCfOrder> findAllByOrderTimeLessThanAndOrderStatus(Date orderTime, Integer orderStatus);
}
