package com.example.afrishop_v3.repository;

import com.example.afrishop_v3.models.TbCfExchange;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;

@Service("tbCfExchangeRepository")
public interface TbCfExchangeRepository extends PagingAndSortingRepository<TbCfExchange,String> {
    TbCfExchange findByExchangeCurrency(String exchangeCurrency);

    @Transactional
    @Query(value = "update  tb_cf_exchange WHERE type=:type SET exchange_rate = :rate ",nativeQuery = true)
    @Modifying
    void updateByType(@Param("type") String type,@Param("rate") BigDecimal rate);
}
