package com.example.afrishop_v3.repository;

import com.example.afrishop_v3.models.TbCfCartRecordR;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Optional;

public interface TbCfCartRecordRRepository extends PagingAndSortingRepository<TbCfCartRecordR, String> {
    int countByUserId(String userId);

    Optional<TbCfCartRecordR> findFirstByUserIdAndItemIdAndItemSku(String userId, String itemId, String itemSku);

    Optional<TbCfCartRecordR> findFirstByUserIdAndItemImgAndItemSku(String userId, String itemImg, String itemSku);

    Optional<TbCfCartRecordR> findFirstByUserIdAndSourceItemIdAndItemSku(String userId, String sourceItemId, String itemSku);

    List<TbCfCartRecordR> findAllByUserIdOrderByCreateTimeDesc(String userId);
    List<TbCfCartRecordR> findAllByCartRecordIdIn(String[] ids);


    @Transactional
    void deleteAllByCartRecordIdIn(String[] ids);
}
