package com.example.afrishop_v3.repository;

import com.example.afrishop_v3.models.TbCfAddress;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface TbCfAddressRepository extends PagingAndSortingRepository<TbCfAddress,String> {
    List<TbCfAddress> findAllByUserId(String userId);

    @Transactional
    @Modifying
    @Query(value = "update tb_cf_address set default_flag=0 where user_id=:user_id",nativeQuery = true)
    void resetToDefault(@Param("user_id") String userId);

    boolean existsByAddressDetailAndUserId(String addressDetail, String userId);

    boolean existsByAddressDetailAndUserIdAndAddressIdIsNot(String addressDetail, String userId, String addressId);
}
