package com.example.afrishop_v3.repository;

import com.example.afrishop_v3.models.Bonus;
import com.example.afrishop_v3.models.TbCfUserInfo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

public interface BonusRepository extends JpaRepository<Bonus,String> {
    Page<Bonus> findAllByUserInfo_UserIdOrderByCreateDateDesc(String id, Pageable pageable);
    @Query(value = "select a from #{#entityName} a WHERE month(a.createDate) = :month and year(a.createDate) = :year and a.userInfo=:id order by a.createDate desc")
    Page<Bonus> findAllByUser_IdAndCreateDateMonthAndCreateDateYear(TbCfUserInfo id, int month, int year, Pageable pageable);
    @Query(value = "select a from #{#entityName} a WHERE dayofyear(a.createDate) = :day and year(a.createDate) = :year and a.userInfo=:id order by a.createDate desc")
    Page<Bonus> findAllByUser_IdAndCreateDate(TbCfUserInfo id, int day, int year, Pageable pageable);
    Page<Bonus> findAllByUserInfo_UserIdAndWithdraw(String id, boolean withdraw, Pageable pageable);

    @Query(value = "delete from bonus WHERE post_id=:post",nativeQuery = true)
    @Modifying
    @Transactional
    void removeByPost_Id(@Param("post") String post_id);

    boolean existsByOrderId(String orderId);



}
