package com.example.afrishop_v3.quartz;


import com.example.afrishop_v3.repository.TbCfExchangeRepository;
import com.example.afrishop_v3.repository.UserRepository;
import com.example.afrishop_v3.util.HttpClientUtil;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.URISyntaxException;


@Component
public class QuartzMethod {
    private final UserRepository userRepository;

    private final TbCfExchangeRepository exchangeRepository;

    public QuartzMethod(UserRepository userRepository, @Qualifier("tbCfExchangeRepository") TbCfExchangeRepository exchangeRepository) {
        this.userRepository = userRepository;
        this.exchangeRepository = exchangeRepository;
    }

//    //@Scheduled(cron = "0 0/1 * * * ? ")
//    public  void sendEmail() throws EmailException, TemplateException, IOException {
//        System.out.println("////////////////////////////////////////////////////");
//      String email= tbCfUserInfoService.findEmails();
//      //  String email= "1203063316@qq.com";
//        if(email!=null){
//            String s = tbCfUserInfoService.sendRegister(email);
//            if(s!=null){
//                System.out.println("已发送邮件:"+email);
//            }
//        }
//    }

    /**
     * 美元-克瓦查
     * @throws IOException
     * @throws URISyntaxException
     */
    @Scheduled(cron = "0 0 3 * * ?")
    public void  getRent() throws IOException, URISyntaxException {
        String content = HttpClientUtil.getContentByUrl("https://cn.valutafx.com/USD-ZMW.htm?amount=1", "rent");
        // 解析为 Document 对象
        Document document = Jsoup.parse(content);
        String rent = document.select("div[class=rate-value]").text();
        BigDecimal rate=new BigDecimal(rent);
        String type="USD-ZMW";
        exchangeRepository.updateByType(type,rate);
    }

    /**
     * 美元-人民币
     * @throws IOException
     * @throws URISyntaxException
     */
    @Scheduled(cron = "0 0 3 * * ?")
    public void  getRate() throws IOException, URISyntaxException {
        String content = HttpClientUtil.getContentByUrl("https://cn.valutafx.com/USD-CNY.htm?amount=1", "rent");
        // 解析为 Document 对象
        Document document = Jsoup.parse(content);
        String rent = document.select("div[class=rate-value]").text();
        BigDecimal rate=new BigDecimal(rent);
        String type="USD-CNY";
        exchangeRepository.updateByType(type,rate);
    }
}
