package com.example.afrishop_v3.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 站点商品实体
 * 表名 tb_cf_station_item
 *
 * @author lipengjun
 * @date 2020-03-14 10:16:03
 */

@Entity
@Getter
@Setter
@Where(clause="enable_flag=1")
public class TbCfStationItem {


    /**
     * 商品id
     */
    @Id
    @Column(length = 64)
    private String itemId;
    /**
     * 商品编号
     */
    private String itemCode;
    /**
     * 商品名字
     */
    private String itemName;
    /**
     * 商品标题
     */
    private String itemBrief;
    /**
     * 商品一级分类
     */
    private String itemCategory;
    /**
     * 商品价格
     */
    private BigDecimal itemPrice;
    /**
     * 商品折扣价
     */
    private BigDecimal discountPrice;

    /**
     * 商品链接
     */
    private String itemUrl;
    /**
     * 商品图片
     */
    private String itemImg;
    /**
     * 搜索关键字
     */
    private String itemTags;
    /**
     * 商品标签
     */
    private String itemLabel;
    /**
     * 浏览人数
     */
    private Long itemNum;
    /**
     * 收藏人数
     */
    private Long itemCollectionNum;
    /**
     * 商品库存
     */
    private Long itemCount;
    /**
     * 商品规格
     */
    private String itemSku;
    /**
     * 是否置顶 Y:是 N:否
     */
    private String itemTop;
    /**
     * 供应商
     */
    private String supplier;
    /**
     * 所属平台
     */
    private String platformCode;
    /**
     * 平台名
     */
    private String platformName;
    /**
     * 状态 0、删除 1、上架 2、下架
     */
    private Integer enableFlag;
    /**
     * 创建日期
     */
    private Date createTime;
    /**
     * 商品二级分类
     */
    private String itemCategorytwo;
    /**
     * 商品品名
     */
    private String itemDescritionId;

    private Integer sort;

    @JsonIgnore
    @ManyToOne
    @JoinColumn(columnDefinition = "template",name = "template")
    private TbCfExpressTemplate express;

    @Formula(value = "(SELECT IFNULL(CEILING(SUM((a.item_score+a.service_score+a.logistics_score+a.price_score)/4)/COUNT(a.item_id)),5) FROM tb_cf_item_comment a WHERE a.item_id=item_id)")
    private int totalScore = 0;


    @JsonIgnore
    @OneToMany(mappedBy = "item", cascade = CascadeType.ALL)
    private List<ItemLabel> labelList = new ArrayList<>();


    public TbCfExpressTemplate getExpress() {
        return express;
    }

    public List<ItemLabel> getLabelList() {
        return labelList;
    }

    /**
     * 设置：商品id
     */
    public void setItemId(String itemId) {
        this.itemId = itemId;
    }


    public void setLabelList(List<ItemLabel> labelList) {
        this.labelList = labelList;
    }

    /**
     * 获取：商品id
     */
    public String getItemId() {
        return itemId;
    }

    /**
     * 设置：商品编号
     */
    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    /**
     * 获取：商品编号
     */
    public String getItemCode() {
        return itemCode;
    }

    public int getTotalScore() {
        return totalScore;
    }

    public BigDecimal getOneOfPrices(){
        return discountPrice == null ? itemPrice == null ? BigDecimal.ZERO : itemPrice : discountPrice;
    }

    /**
     * 设置：商品名字
     */
    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    /**
     * 获取：商品名字
     */
    public String getItemName() {
        return itemName;
    }

    /**
     * 设置：商品标题
     */
    public void setItemBrief(String itemBrief) {
        this.itemBrief = itemBrief;
    }

    /**
     * 获取：商品标题
     */
    public String getItemBrief() {
        return itemBrief;
    }

    /**
     * 设置：商品一级分类
     */
    public void setItemCategory(String itemCategory) {
        this.itemCategory = itemCategory;
    }

    /**
     * 获取：商品一级分类
     */
    public String getItemCategory() {
        return itemCategory;
    }

    /**
     * 设置：商品价格
     */
    public void setItemPrice(BigDecimal itemPrice) {
        this.itemPrice = itemPrice;
    }

    /**
     * 获取：商品价格
     */
    public BigDecimal getItemPrice() {
        return itemPrice;
    }

    /**
     * 设置：商品折扣价
     */
    public void setDiscountPrice(BigDecimal discountPrice) {
        this.discountPrice = discountPrice;
    }

    /**
     * 获取：商品折扣价
     */
    public BigDecimal getDiscountPrice() {
        return discountPrice;
    }

    /**
     * 设置：商品链接
     */
    public void setItemUrl(String itemUrl) {
        this.itemUrl = itemUrl;
    }

    /**
     * 获取：商品链接
     */
    public String getItemUrl() {
        return itemUrl;
    }

    /**
     * 设置：商品图片
     */
    public void setItemImg(String itemImg) {
        itemImg = itemImg.split(";")[0];
        this.itemImg = itemImg;
    }

    /**
     * 获取：商品图片
     */
    public String getItemImg() {
        return itemImg;
    }


    public String catchSingleImage(){
        String itemImg = getItemImg();
        String[] strings = itemImg != null ? itemImg.split(";") : new String[]{};
        return strings.length > 0 ? strings[0] : itemImg;
    }
    /**
     * 设置：搜索关键字
     */
    public void setItemTags(String itemTags) {
        this.itemTags = itemTags;
    }

    /**
     * 获取：搜索关键字
     */
    public String getItemTags() {
        return itemTags;
    }

    /**
     * 设置：商品标签
     */
    public void setItemLabel(String itemLabel) {
        this.itemLabel = itemLabel;
    }

    /**
     * 获取：商品标签
     */
    public String getItemLabel() {
        return itemLabel;
    }

    /**
     * 设置：浏览人数
     */
    public void setItemNum(Long itemNum) {
        this.itemNum = itemNum;
    }

    /**
     * 获取：浏览人数
     */
    public Long getItemNum() {
        return itemNum;
    }

    /**
     * 设置：收藏人数
     */
    public void setItemCollectionNum(Long itemCollectionNum) {
        this.itemCollectionNum = itemCollectionNum;
    }

    /**
     * 获取：收藏人数
     */
    public Long getItemCollectionNum() {
        return itemCollectionNum;
    }

    /**
     * 设置：商品库存
     */
    public void setItemCount(Long itemCount) {
        this.itemCount = itemCount;
    }

    /**
     * 获取：商品库存
     */
    public Long getItemCount() {
        return itemCount;
    }

    /**
     * 设置：商品规格
     */
    public void setItemSku(String itemSku) {
        this.itemSku = itemSku;
    }

    /**
     * 获取：商品规格
     */
    public String getItemSku() {
        return itemSku;
    }

    /**
     * 设置：是否置顶 Y:是 N:否
     */
    public void setItemTop(String itemTop) {
        this.itemTop = itemTop;
    }

    /**
     * 获取：是否置顶 Y:是 N:否
     */
    public String getItemTop() {
        return itemTop;
    }

    /**
     * 设置：供应商
     */
    public void setSupplier(String supplier) {
        this.supplier = supplier;
    }

    /**
     * 获取：供应商
     */
    public String getSupplier() {
        return supplier;
    }

    /**
     * 设置：所属平台
     */
    public void setPlatformCode(String platformCode) {
        this.platformCode = platformCode;
    }

    /**
     * 获取：所属平台
     */
    public String getPlatformCode() {
        return platformCode;
    }

    /**
     * 设置：平台名
     */
    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }

    /**
     * 获取：平台名
     */
    public String getPlatformName() {
        return platformName;
    }

    /**
     * 设置：状态 0、删除 1、上架 2、下架
     */
    public void setEnableFlag(Integer enableFlag) {
        this.enableFlag = enableFlag;
    }

    /**
     * 获取：状态 0、删除 1、上架 2、下架
     */
    public Integer getEnableFlag() {
        return enableFlag;
    }

    /**
     * 设置：创建日期
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取：创建日期
     */
    public Date getCreateTime() {
        return createTime;
    }

    /**
     * 设置：商品二级分类
     */
    public void setItemCategorytwo(String itemCategorytwo) {
        this.itemCategorytwo = itemCategorytwo;
    }

    /**
     * 获取：商品二级分类
     */
    public String getItemCategorytwo() {
        return itemCategorytwo;
    }

    /**
     * 设置：商品品名
     */
    public void setItemDescritionId(String itemDescritionId) {
        this.itemDescritionId = itemDescritionId;
    }

    /**
     * 获取：商品品名
     */
    public String getItemDescritionId() {
        return itemDescritionId;
    }

}
