package com.example.afrishop_v3.models;

import com.example.afrishop_v3.base.StateConstant;
import com.example.afrishop_v3.enums.OrderStatusEnum;
import com.example.afrishop_v3.util.IdUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

/**
 * 订单商品对应表实体
 * 表名 tb_cf_item_order_r
 *
 * @author G
 * @date 2019-08-14 09:11:48
 */
@Entity
@Data
@Table(name = "tb_cf_item_order_r")
@Where(clause = "enable_flag = 1")
public class TbCfItemOrderR {

    /**
     * 记录表
     */
    @Id
    private String orderItemId;
    /**
     * 商品id
     */
    private String itemId;
    /**
     * 订单id
     */
    private String orderId;
    /**
     * 是否有效
     */
    private Integer enableFlag;

    private  Integer orderStatus;

    private Integer deliveryFlag;
    /**
     * 是否已发送短信
     */
    private Integer isSend;

    private Date deliveryTime;
    private Date closeTime;
    private Date updateTime;

    private Integer itemNum;

    private String itemImg;

    private String itemTitle;

    private String itemSku;

    private String shopName;

    private String shopUrl;

    private String shopId;






    @JsonIgnore @ManyToOne
    private TbCfExpressTemplate template;

    @Transient
    private String cartRecordId;

    TbCfItemOrderR(String id,String orderId,String itemId,Integer itemNum,BigDecimal itemPrice,TbCfExpressTemplate template,String itemImg,String itemSku,String itemTitle,String shopId,String shopName,String shopUrl){
        this.itemNum = itemNum;
        this.cartRecordId = id;
        this.orderId = orderId;
        this.orderItemId = IdUtil.createIdbyUUID();
        this.itemPrice = itemPrice;
        this.template = template;
        this.itemId = itemId;
        this.itemImg = itemImg;
        this.itemSku = itemSku;
        this.itemTitle = itemTitle;
        this.enableFlag = StateConstant.VALID;
        this.orderStatus = OrderStatusEnum.PENDING_PAY.getValue();
        this.shopId = shopId;
        this.shopName = shopName;
        this.shopUrl = shopUrl;
    }

    TbCfItemOrderR(){

    }
    /**
     * 商品价格
     */
    private BigDecimal itemPrice;

    public Integer getItemNum() {
        return itemNum;
    }

    public void setItemNum(Integer itemNum) {
        this.itemNum = itemNum;
    }


    public TbCfExpressTemplate getTemplate() {
        return template;
    }

    public BigDecimal getItemPrice() {
        return itemPrice == null ? BigDecimal.ZERO.setScale(2, RoundingMode.CEILING) : itemPrice;
    }

    /**
     * 设置：记录表
     */
    public void setOrderItemId(String orderItemId) {
        this.orderItemId = orderItemId;
    }


    public BigDecimal getItemPriceTotal() {
        return itemPrice == null || itemNum == null ? BigDecimal.ZERO : itemPrice.multiply(BigDecimal.valueOf(itemNum));
    }

    /**
     * 获取：记录表
     */
    public String getOrderItemId() {
        return orderItemId;
    }
    /**
     * 设置：商品id
     */
    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    /**
     * 获取：商品id
     */
    public String getItemId() {
        return itemId;
    }
    /**
     * 设置：订单id
     */
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    /**
     * 获取：订单id
     */
    public String getOrderId() {
        return orderId;
    }
    /**
     * 设置：是否有效
     */
    public void setEnableFlag(Integer enableFlag) {
        this.enableFlag = enableFlag;
    }

    /**
     * 获取：是否有效
     */
    public Integer getEnableFlag() {
        return enableFlag;
    }

    public Integer getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Integer getDeliveryFlag() {
        return deliveryFlag;
    }

    public void setDeliveryFlag(Integer deliveryFlag) {
        this.deliveryFlag = deliveryFlag;
    }

    public Date getDeliveryTime() {
        return deliveryTime;
    }

    public void setDeliveryTime(Date deliveryTime) {
        this.deliveryTime = deliveryTime;
    }

    public Date getCloseTime() {
        return closeTime;
    }

    public void setCloseTime(Date closeTime) {
        this.closeTime = closeTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getIsSend() {
        return isSend;
    }

    public void setIsSend(Integer isSend) {
        this.isSend = isSend;
    }
}
