package com.example.afrishop_v3.models;

import lombok.Data;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 购物车记录表实体
 * 表名 tb_cf_cart_record_r
 *
 * @author G
 * @date 2019-08-16 15:51:16
 */
@Entity
@Table(name = "tb_cf_cart_record_r")
@Data
@Where(clause = "enable_flag=1")
public class TbCfCartRecordR {

    /**
     * 购物车记录id
     */
    @Id
    private String cartRecordId;


    /**
     * 用户id
     */
    private String userId;

    private String itemId;

    private String itemImg;

    private String itemTitle;


    private String itemCategory;
    /**
     * 是否已经被勾选，0未勾选，1勾选
     */
    private Integer checkFlag;
    /**
     * 是否有效
     */
    private Integer enableFlag;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 商品链接
     */
    private String sourceItemId;
    /**
     * 商品SKU
     */
    private String itemSku;

    private String shopName;

    private String shopUrl;

    private String shopId;
    /**
     * 商品SKU
     */
    private Integer itemNum;


    @ManyToOne
    private TbCfExpressTemplate template;
    /**
     * 状态 0：已删除 1：加入购物车 2：直接支付（预留）
     */
    private Integer status;

    /**
     * 商品价格
     */
    private BigDecimal itemPrice;


    public TbCfCartRecordR(){
        this.shopName = "afrishop";
    }


    public void setItemImg(String itemImg) {
        this.itemImg = itemImg;
    }

    public BigDecimal getItemPrice() {
        return itemPrice;
    }

    public BigDecimal getItemPriceTotal() {
        return itemPrice.multiply(BigDecimal.valueOf(itemNum));
    }

    public void setItemPrice(BigDecimal itemPrice) {
        this.itemPrice = itemPrice;
    }

    /**
     * 设置：购物车记录id
     */
    public void setCartRecordId(String cartRecordId) {
        this.cartRecordId = cartRecordId;
    }

    /**
     * 获取：购物车记录id
     */
    public String getCartRecordId() {
        return cartRecordId;
    }


    public String getItemImg() {
        return itemImg;
    }
    /**
     * 设置：商品分类
     */
    public void setItemCategory(String itemCategory) {
        this.itemCategory = itemCategory;
    }
    /**
     * 获取：商品分类
     */
    public String getItemCategory() {
        return itemCategory;
    }
    /**
     * 设置：状态 0：已删除 1：加入购物车 2：直接支付（预留）
     */
    public void setStatus(Integer status) {
        this.status = status;
    }



    /**
     * 获取：状态 0：已删除 1：加入购物车 2：直接支付（预留）
     */
    public Integer getStatus() {
        return status;
    }

    /**
     * 设置：用户id
     */
    public void setUserId(String userId) {
        this.userId = userId;
    }

    /**
     * 获取：用户id
     */
    public String getUserId() {
        return userId;
    }

    /**
     * 设置：是否已经被勾选，0未勾选，1勾选
     */
    public void setCheckFlag(Integer checkFlag) {
        this.checkFlag = checkFlag;
    }

    /**
     * 获取：是否已经被勾选，0未勾选，1勾选
     */
    public Integer getCheckFlag() {
        return checkFlag;
    }


    /**
     * 设置：是否有效
     */
    public void setEnableFlag(Integer enableFlag) {
        this.enableFlag = enableFlag;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getItemId() {
        return itemId;
    }

    TbCfItemOrderR getOrderItem(String orderId){
        if( template == null ) System.out.println("Template is null");
        return new TbCfItemOrderR(cartRecordId,orderId,itemId,itemNum,itemPrice,template,itemImg,itemSku,itemTitle,shopId,shopName,shopUrl);
    }

    public void setTemplate(TbCfExpressTemplate template) {
        this.template = template;
    }

    public void setItemTitle(String itemTitle) {
        this.itemTitle = itemTitle;
    }


    public String getItemTitle() {
        return itemTitle;
    }


    public TbCfExpressTemplate getTemplate() {
        return template;
    }

    /**
     * 获取：是否有效
     */
    public Integer getEnableFlag() {
        return enableFlag;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getSourceItemId() {
        return sourceItemId;
    }

    public void setSourceItemId(String sourceItemId) {
        this.sourceItemId = sourceItemId;
    }

    public String getItemSku() {
        return itemSku;
    }

    public void setItemSku(String itemSku) {
        this.itemSku = itemSku;
    }

    public Integer getItemNum() {
        return itemNum;
    }

    public void increaseNum(Integer itemNum) {
        setItemNum(this.itemNum + itemNum);
    }

    public void setItemNum(Integer itemNum) {
        this.itemNum = itemNum;
    }
}
