package com.example.afrishop_v3.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;

@Entity
@Getter
@Setter
public class ContentTag extends Model {

    @JsonIgnore
    @ManyToOne(cascade = CascadeType.ALL)
    private Content content;

    @ManyToOne(cascade = CascadeType.ALL)
    private Tag tag;

    private double x;
    private double y;


    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    public void setTag(Tag tag) {
        this.tag = tag;
    }

    public Tag getTag() {
        return tag;
    }


    public double getX() {
        return x;
    }

    public double getY() {
        return y;
    }
}

