package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.models.TbCfItemComment;
import com.example.afrishop_v3.repository.TbCfItemCommentRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("shopify")
public class ShopifyController {
    private final TbCfItemCommentRepository repository;

    public ShopifyController(TbCfItemCommentRepository repository) {
        this.repository = repository;
    }

    @GetMapping("/querycomments")
    public Result queryComments(@RequestParam(value = "itemId") String itemId,
                                 @RequestParam(value = "pageNum", defaultValue = "0") Integer pageNum,
                                @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize,
                                @RequestParam(value = "userId", required = false) String userId) {
        Page<TbCfItemComment> list = repository.findAllByItemId(itemId, PageRequest.of(pageNum, pageSize));
        List<TbCfItemComment> content = list.getContent();
        for (TbCfItemComment item : content){
            //if(StringUtils.isNotBlank(userId)) item.setLike(repository.existsByUserIdAndItemId(userId,itemId));
        }
        return new Result<>(list);
    }
}
