package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.enums.ResultCodeEnum;
import com.example.afrishop_v3.models.TbCfSearch;
import com.example.afrishop_v3.repository.TbCfSearchRepository;
import com.example.afrishop_v3.security.services.AuthenticationUser;
import com.example.afrishop_v3.util.IdUtil;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/search")
public class SearchController {
    private final TbCfSearchRepository repository;

    private final AuthenticationUser user;

    public SearchController(TbCfSearchRepository repository, AuthenticationUser authenticationUser) {
        this.repository = repository;
        this.user = authenticationUser;
    }

    @PostMapping("/save")
    public Result save(@RequestBody TbCfSearch tbCfSearch) {

        tbCfSearch.setId(IdUtil.createIdbyUUID());

        tbCfSearch.setUserId(user.userId());

        TbCfSearch entity = repository.save(tbCfSearch);

        return new Result<>(entity);
    }

    @GetMapping("/getRecords")
    public Result getRecords() {
        List<TbCfSearch> list = repository.getAllByUserId(user.userId());
        return new Result<>(list);
    }

    @DeleteMapping("/deleteRecords")
    public Result deleteRecords(@RequestBody String[] ids) {
        if (ids != null) {
            repository.deleteAllByIdIn(ids);
            return new Result();
        }
        return new Result(ResultCodeEnum.SERVICE_ERROR.getCode(),
                ResultCodeEnum.SERVICE_ERROR.getDesc());
    }
}
