package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.repository.TbCfProblemRepository;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/problem")
public class ProblemController {
    private final TbCfProblemRepository repository;

    public ProblemController(TbCfProblemRepository repository) {
        this.repository = repository;
    }

    @GetMapping
    public Result getProblemList(@RequestParam(required = false) Integer pageNum,
                                           @RequestParam(required = false) Integer pageSize) {
        pageNum = pageNum == null ? 1 : pageNum;
        pageSize = pageSize == null ? 10 : pageSize;
        return new Result<>(repository.findAll(PageRequest.of(pageNum,pageSize)));

    }
}
