package com.example.afrishop_v3.controllers;


import com.example.afrishop_v3.models.PostLike;
import com.example.afrishop_v3.repository.LikeRepository;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/discover/like")
public class LikeController {
    private final LikeRepository repository;

    public LikeController(LikeRepository repository) {
        this.repository = repository;
    }


    @GetMapping(value = "/likesByPostId/{postId}")
    //@PreAuthorize("hasAuthority('ADMIN_USER') or hasAuthority('STANDARD_USER')")
    public List<PostLike> getList(@PathVariable(value = "postId") String id, @RequestParam(value = "pageNo") Integer pageNo, @RequestParam(value = "pageSize") Integer pageSize) {
        return repository.findAllByPost_Id(id, PageRequest.of(pageNo, pageSize)).toList();
    }


    @PostMapping(value = "/saveLike/{status}")
    public String saveProduct(@PathVariable(value = "status") boolean status, @ModelAttribute("PostLike") PostLike like) {
        if (status) {
            if( !repository.existsByUserInfo_UserIdAndPost_Id(like.getUserId(),like.getPostId())) repository.save(like);
        }else repository.removeByUser_IdAndPost_Id(like.getUserId(), like.getPostId());
        return "delete";
    }
}
